/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.StringCompare;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SequenceList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final PdfName[] vpnames = new PdfName[]{PdfName.HIDETOOLBAR, PdfName.HIDEMENUBAR, PdfName.HIDEWINDOWUI, PdfName.FITWINDOW, PdfName.CENTERWINDOW, PdfName.DISPLAYDOCTITLE};
    static final int[] vpints = new int[]{256, 512, 1024, 2048, 4096, 262144};
    static final byte[] endstream = PdfEncodings.convertToBytes("endstream", null);
    static final byte[] endobj = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected HashMap objStmMark;
    protected boolean newXrefType;
    protected ArrayList xrefObj;
    protected PdfDictionary trailer;
    protected ArrayList pages;
    protected PdfDictionary catalog;
    protected ArrayList pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected ArrayList pageInh;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected int rValue;
    protected int pValue;
    private int objNum;
    private int objGen;
    private boolean[] visited;
    private IntHashtable newHits;
    private int fileLength;
    private boolean hybridXref;
    private boolean appendable;

    protected PdfReader() {
    }

    public PdfReader(String string) throws IOException {
        this(string, null);
    }

    public PdfReader(String string, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this(byArray, null);
    }

    public PdfReader(byte[] byArray, byte[] byArray2) throws IOException {
        this.password = byArray2;
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public PdfReader(URL uRL) throws IOException {
        this(uRL, null);
    }

    public PdfReader(URL uRL, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(uRL));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(inputStream));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public PdfReader(PdfReader pdfReader) {
        int n;
        this.appendable = pdfReader.appendable;
        this.consolidateNamedDestinations = pdfReader.consolidateNamedDestinations;
        this.encrypted = pdfReader.encrypted;
        this.rebuilt = pdfReader.rebuilt;
        this.sharedStreams = pdfReader.sharedStreams;
        this.tampered = pdfReader.tampered;
        this.password = pdfReader.password;
        this.pdfVersion = pdfReader.pdfVersion;
        this.eofPos = pdfReader.eofPos;
        this.freeXref = pdfReader.freeXref;
        this.lastXref = pdfReader.lastXref;
        this.tokens = pdfReader.tokens;
        this.decrypt = pdfReader.decrypt;
        this.pValue = pdfReader.pValue;
        this.rValue = pdfReader.rValue;
        this.xrefObj = new ArrayList(pdfReader.xrefObj);
        for (n = 0; n < pdfReader.xrefObj.size(); ++n) {
            this.xrefObj.set(n, PdfReader.duplicatePdfObject((PdfObject)pdfReader.xrefObj.get(n), this));
        }
        this.pageRefs = new ArrayList(pdfReader.pageRefs);
        this.pages = new ArrayList(pdfReader.pages);
        for (n = 0; n < pdfReader.pageRefs.size(); ++n) {
            this.pageRefs.set(n, PdfReader.duplicatePdfObject((PdfObject)pdfReader.pageRefs.get(n), this));
            this.pages.set(n, PdfReader.getPdfObject((PdfObject)this.pageRefs.get(n)));
        }
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(pdfReader.trailer, this);
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.fileLength = pdfReader.fileLength;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        if (!this.acroFormParsed) {
            this.acroFormParsed = true;
            PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
            if (pdfObject != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(pdfObject));
                }
                catch (Exception exception) {
                    this.acroForm = null;
                }
            }
        }
        return this.acroForm;
    }

    public int getPageRotation(int n) {
        return this.getPageRotation((PdfDictionary)this.pages.get(n - 1));
    }

    int getPageRotation(PdfDictionary pdfDictionary) {
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ROTATE));
        if (pdfNumber == null) {
            return 0;
        }
        int n = pdfNumber.intValue();
        return (n %= 360) < 0 ? n + 360 : n;
    }

    public Rectangle getPageSizeWithRotation(int n) {
        return this.getPageSizeWithRotation((PdfDictionary)this.pages.get(n - 1));
    }

    public Rectangle getPageSizeWithRotation(PdfDictionary pdfDictionary) {
        Rectangle rectangle = this.getPageSize(pdfDictionary);
        for (int i = this.getPageRotation(pdfDictionary); i > 0; i -= 90) {
            rectangle = rectangle.rotate();
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n) {
        return this.getPageSize((PdfDictionary)this.pages.get(n - 1));
    }

    public Rectangle getPageSize(PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getCropBox(int n) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.pages.get(n - 1);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(n);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getBoxSize(int n, String string) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.pages.get(n - 1);
        PdfArray pdfArray = null;
        if (string.equals("trim")) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.TRIMBOX));
        } else if (string.equals("art")) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ARTBOX));
        } else if (string.equals("bleed")) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BLEEDBOX));
        } else if (string.equals("crop")) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CROPBOX));
        } else if (string.equals("media")) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        }
        if (pdfArray == null) {
            return null;
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public HashMap getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (pdfDictionary == null) {
            return hashMap;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    string = ((PdfString)pdfObject).toUnicodeString();
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        ArrayList arrayList = pdfArray.getArrayList();
        float f = ((PdfNumber)arrayList.get(0)).floatValue();
        float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
        float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
        float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
        return new Rectangle(Math.min(f, f3), Math.min(f2, f4), Math.max(f, f3), Math.max(f2, f4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPdf() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            try {
                this.readDocObj();
            }
            catch (IOException iOException) {
                if (this.rebuilt) {
                    throw iOException;
                }
                this.rebuilt = true;
                this.encrypted = false;
                this.rebuildXref();
                this.lastXref = -1;
                this.readDocObj();
            }
            this.strings.clear();
            this.readPages();
            this.eliminateSharedStreams();
            this.removeUnusedObjects();
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean equalsArray(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void readDecryptedDocObj() throws IOException {
        String string;
        PdfObject pdfObject;
        if (this.encrypted) {
            return;
        }
        PdfObject pdfObject2 = this.trailer.get(PdfName.ENCRYPT);
        if (pdfObject2 == null || pdfObject2.toString().equals("null")) {
            return;
        }
        this.encrypted = true;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] byArray = null;
        if (pdfArray != null) {
            pdfObject = (PdfObject)pdfArray.getArrayList().get(0);
            string = pdfObject.toString();
            byArray = DocWriter.getISOBytes(string);
        }
        string = pdfDictionary.get(PdfName.U).toString();
        byte[] byArray2 = DocWriter.getISOBytes(string);
        string = pdfDictionary.get(PdfName.O).toString();
        byte[] byArray3 = DocWriter.getISOBytes(string);
        pdfObject = pdfDictionary.get(PdfName.R);
        if (!pdfObject.isNumber()) {
            throw new IOException("Illegal R value.");
        }
        this.rValue = ((PdfNumber)pdfObject).intValue();
        if (this.rValue != 2 && this.rValue != 3) {
            throw new IOException("Unknown encryption type (" + this.rValue + ")");
        }
        pdfObject = pdfDictionary.get(PdfName.P);
        if (!pdfObject.isNumber()) {
            throw new IOException("Illegal P value.");
        }
        this.pValue = ((PdfNumber)pdfObject).intValue();
        this.decrypt = new PdfEncryption();
        this.decrypt.setupByUserPassword(byArray, this.password, byArray3, this.pValue, this.rValue == 3);
        if (!this.equalsArray(byArray2, this.decrypt.userKey, this.rValue == 3 ? 16 : 32)) {
            this.decrypt.setupByOwnerPassword(byArray, this.password, byArray2, byArray3, this.pValue, this.rValue == 3);
            if (!Arrays.equals(byArray2, this.decrypt.userKey)) {
                throw new IOException("Bad user password");
            }
        }
        for (int i = 0; i < this.strings.size(); ++i) {
            PdfString pdfString = (PdfString)this.strings.get(i);
            pdfString.decrypt(this);
        }
        if (pdfObject2.isIndirect()) {
            this.xrefObj.set(((PRIndirectReference)pdfObject2).getNumber(), null);
        }
    }

    public static PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            return pdfObject;
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
        int n = pRIndirectReference.getNumber();
        boolean bl = pRIndirectReference.getReader().appendable;
        pdfObject = (PdfObject)pRIndirectReference.getReader().xrefObj.get(n);
        if (pdfObject == null) {
            if (bl) {
                pdfObject = new PdfNull();
                pdfObject.setIndRef(pRIndirectReference);
                return pdfObject;
            }
            return PdfNull.PDFNULL;
        }
        if (bl) {
            switch (pdfObject.type()) {
                case 8: {
                    pdfObject = new PdfNull();
                    break;
                }
                case 1: {
                    pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                    break;
                }
                case 4: {
                    pdfObject = new PdfName(pdfObject.getBytes());
                }
            }
            pdfObject.setIndRef(pRIndirectReference);
        }
        return pdfObject;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject, PdfObject pdfObject2) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = null;
            if (pdfObject2 != null && (pRIndirectReference = pdfObject2.getIndRef()) != null && pRIndirectReference.getReader().isAppendable()) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef(pRIndirectReference);
            }
            return pdfObject;
        }
        return PdfReader.getPdfObject(pdfObject);
    }

    protected void pushPageAttributes(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (this.pageInh.size() != 0) {
            pdfDictionary2.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        for (int i = 0; i < pageInhCandidates.length; ++i) {
            PdfObject pdfObject = pdfDictionary.get(pageInhCandidates[i]);
            if (pdfObject == null) continue;
            pdfDictionary2.put(pageInhCandidates[i], pdfObject);
        }
        this.pageInh.add(pdfDictionary2);
    }

    protected void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    protected void iteratePages(PRIndirectReference pRIndirectReference) throws IOException {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGE);
            PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
            Object object = pdfDictionary2.getKeys().iterator();
            while (object.hasNext()) {
                PdfName pdfName = (PdfName)object.next();
                if (pdfDictionary.get(pdfName) != null) continue;
                pdfDictionary.put(pdfName, pdfDictionary2.get(pdfName));
            }
            if (pdfDictionary.get(PdfName.MEDIABOX) == null) {
                object = new PdfArray(new float[]{0.0f, 0.0f, PageSize.LETTER.right(), PageSize.LETTER.top()});
                pdfDictionary.put(PdfName.MEDIABOX, (PdfObject)object);
            }
            this.pages.add(pdfDictionary);
            this.pageRefs.add(pRIndirectReference);
        } else {
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
            this.pushPageAttributes(pdfDictionary);
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.iteratePages((PRIndirectReference)arrayList.get(i));
            }
            this.popPageAttributes();
        }
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.pages = new ArrayList();
        this.pageRefs = new ArrayList();
        this.iteratePages((PRIndirectReference)this.catalog.get(PdfName.PAGES));
        this.pageInh = null;
        pdfDictionary.put(PdfName.COUNT, new PdfNumber(this.pages.size()));
    }

    protected void PRSimpleRecursive(PdfObject pdfObject) throws IOException {
        switch (pdfObject.type()) {
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    this.PRSimpleRecursive(pdfDictionary.get(pdfName));
                }
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.PRSimpleRecursive((PdfObject)arrayList.get(i));
                }
                break;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                int n = pRIndirectReference.getNumber();
                if (this.visited[n]) break;
                this.visited[n] = true;
                this.newHits.put(n, 1);
            }
        }
    }

    protected void readDocObj() throws IOException {
        Object object;
        int n;
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll(Collections.nCopies(this.xref.length / 2, null));
        for (n = 2; n < this.xref.length; n += 2) {
            PdfObject pdfObject;
            int n2 = this.xref[n];
            if (n2 <= 0 || this.xref[n + 1] > 0) continue;
            this.tokens.seek(n2);
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Invalid object number.");
            }
            this.objNum = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Invalid generation number.");
            }
            this.objGen = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (!this.tokens.getStringValue().equals("obj")) {
                this.tokens.throwError("Token 'obj' expected.");
            }
            try {
                pdfObject = this.readPRObject();
                if (pdfObject.isStream()) {
                    arrayList.add(pdfObject);
                }
            }
            catch (Exception exception) {
                pdfObject = null;
            }
            this.xrefObj.set(n / 2, pdfObject);
        }
        n = this.tokens.length();
        byte[] byArray = new byte[16];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            block16: {
                object = (PRStream)arrayList.get(i);
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.LENGTH));
                int n4 = ((PRStream)object).getOffset();
                n3 = pdfNumber.intValue();
                boolean bl = false;
                if (n3 + n4 > n - 20) {
                    bl = true;
                } else {
                    this.tokens.seek(n4 + n3);
                    String string = this.tokens.readString(20);
                    if (!(string.startsWith("\nendstream") || string.startsWith("\r\nendstream") || string.startsWith("\rendstream") || string.startsWith("endstream"))) {
                        bl = true;
                    }
                }
                if (bl) {
                    int n5;
                    this.tokens.seek(n4);
                    do {
                        n5 = this.tokens.getFilePointer();
                        if (!this.tokens.readLineSegment(byArray)) break block16;
                        if (!PdfReader.equalsn(byArray, endstream)) continue;
                        n3 = n5 - n4;
                        break block16;
                    } while (!PdfReader.equalsn(byArray, endobj));
                    this.tokens.seek(n5 - 16);
                    String string = this.tokens.readString(16);
                    int n6 = string.indexOf("endstream");
                    if (n6 >= 0) {
                        n5 = n5 - 16 + n6;
                    }
                    n3 = n5 - n4;
                }
            }
            ((PRStream)object).setLength(n3);
        }
        this.readDecryptedDocObj();
        if (this.objStmMark != null) {
            Iterator iterator = this.objStmMark.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                int n7 = (Integer)object.getKey();
                IntHashtable intHashtable = (IntHashtable)object.getValue();
                this.readObjStm((PRStream)this.xrefObj.get(n7), intHashtable);
                this.xrefObj.set(n7, null);
            }
            this.objStmMark = null;
        }
        this.xref = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readObjStm(PRStream pRStream, IntHashtable intHashtable) throws IOException {
        int n = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.FIRST))).intValue();
        int n2 = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.N))).intValue();
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser(byArray);
        try {
            int n3;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean bl = true;
            for (n3 = 0; n3 < n2 && (bl = this.tokens.nextToken()); ++n3) {
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                nArray2[n3] = this.tokens.intValue();
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                nArray[n3] = this.tokens.intValue() + n;
            }
            if (!bl) {
                throw new IOException("Error reading ObjStm");
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!intHashtable.containsKey(n3)) continue;
                this.tokens.seek(nArray[n3]);
                PdfObject pdfObject = this.readPRObject();
                this.xrefObj.set(nArray2[n3], pdfObject);
            }
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    static PdfObject killIndirect(PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            return null;
        }
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
        if (pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            pRIndirectReference.getReader().xrefObj.set(pRIndirectReference.getNumber(), null);
        }
        return pdfObject2;
    }

    private void ensureXrefSize(int n) {
        if (n == 0) {
            return;
        }
        if (this.xref == null) {
            this.xref = new int[n];
        } else if (this.xref.length < n) {
            int[] nArray = new int[n];
            System.arraycopy(this.xref, 0, nArray, 0, this.xref.length);
            this.xref = nArray;
        }
    }

    protected void readXref() throws IOException {
        PdfNumber pdfNumber;
        int n;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = n = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        try {
            if (this.readXRefStream(n)) {
                this.newXrefType = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xref = null;
        this.tokens.seek(n);
        PdfDictionary pdfDictionary = this.trailer = this.readXrefSection();
        while ((pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.PREV)) != null) {
            this.tokens.seek(pdfNumber.intValue());
            pdfDictionary = this.readXrefSection();
        }
    }

    protected PdfDictionary readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block2: while (true) {
            int n5;
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n2 = this.tokens.intValue() + n;
            if (n == 1) {
                n5 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                if (n3 == 0 && n4 == 65535) {
                    --n;
                    --n2;
                }
                this.tokens.seek(n5);
            }
            this.ensureXrefSize(n2 * 2);
            n5 = n;
            while (true) {
                if (n5 >= n2) continue block2;
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                int n6 = n5 * 2;
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n6] == 0 && this.xref[n6 + 1] == 0) {
                        this.xref[n6] = n3;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n6] == 0 && this.xref[n6 + 1] == 0) {
                        this.xref[n6] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n5;
            }
            break;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)this.readPRObject();
        PdfNumber pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.SIZE);
        this.ensureXrefSize(pdfNumber.intValue() * 2);
        PdfObject pdfObject = pdfDictionary.get(PdfName.XREFSTM);
        if (pdfObject != null && pdfObject.isNumber()) {
            int n7 = ((PdfNumber)pdfObject).intValue();
            try {
                this.readXRefStream(n7);
                this.newXrefType = true;
                this.hybridXref = true;
            }
            catch (IOException iOException) {
                this.xref = null;
                throw iOException;
            }
        }
        return pdfDictionary;
    }

    protected boolean readXRefStream(int n) throws IOException {
        PdfArray pdfArray;
        this.tokens.seek(n);
        int n2 = 0;
        if (!this.tokens.nextToken()) {
            return false;
        }
        if (this.tokens.getTokenType() != 1) {
            return false;
        }
        n2 = this.tokens.intValue();
        if (!this.tokens.nextToken() || this.tokens.getTokenType() != 1) {
            return false;
        }
        if (!this.tokens.nextToken() || !this.tokens.getStringValue().equals("obj")) {
            return false;
        }
        PdfObject pdfObject = this.readPRObject();
        PRStream pRStream = null;
        if (pdfObject.isStream() && !PdfName.XREF.equals((pRStream = (PRStream)pdfObject).get(PdfName.TYPE))) {
            return false;
        }
        if (this.trailer == null) {
            this.trailer = new PdfDictionary();
            this.trailer.putAll(pRStream);
        }
        pRStream.setLength(((PdfNumber)pRStream.get(PdfName.LENGTH)).intValue());
        int n3 = ((PdfNumber)pRStream.get(PdfName.SIZE)).intValue();
        PdfObject pdfObject2 = pRStream.get(PdfName.INDEX);
        if (pdfObject2 == null) {
            pdfArray = new PdfArray();
            pdfArray.add(new int[]{0, n3});
        } else {
            pdfArray = (PdfArray)pdfObject2;
        }
        PdfArray pdfArray2 = (PdfArray)pRStream.get(PdfName.W);
        int n4 = -1;
        pdfObject2 = pRStream.get(PdfName.PREV);
        if (pdfObject2 != null) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        this.ensureXrefSize(n3 * 2);
        if (this.objStmMark == null) {
            this.objStmMark = new HashMap();
        }
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        int n5 = 0;
        ArrayList arrayList = pdfArray2.getArrayList();
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            nArray[i] = ((PdfNumber)arrayList.get(i)).intValue();
        }
        ArrayList arrayList2 = pdfArray.getArrayList();
        for (int i = 0; i < arrayList2.size(); i += 2) {
            int n6 = ((PdfNumber)arrayList2.get(i)).intValue();
            int n7 = ((PdfNumber)arrayList2.get(i + 1)).intValue();
            this.ensureXrefSize((n6 + n7) * 2);
            while (n7-- > 0) {
                int n8;
                int n9;
                int n10;
                boolean bl = false;
                int n11 = 1;
                if (nArray[0] > 0) {
                    n11 = 0;
                    for (n10 = 0; n10 < nArray[0]; ++n10) {
                        n11 = (n11 << 8) + (byArray[n5++] & 0xFF);
                    }
                }
                n10 = 0;
                for (n9 = 0; n9 < nArray[1]; ++n9) {
                    n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                }
                n9 = 0;
                for (n8 = 0; n8 < nArray[2]; ++n8) {
                    n9 = (n9 << 8) + (byArray[n5++] & 0xFF);
                }
                n8 = n6 * 2;
                if (this.xref[n8] == 0 && this.xref[n8 + 1] == 0) {
                    switch (n11) {
                        case 0: {
                            this.xref[n8] = -1;
                            break;
                        }
                        case 1: {
                            this.xref[n8] = n10;
                            break;
                        }
                        case 2: {
                            this.xref[n8] = n9;
                            this.xref[n8 + 1] = n10;
                            Integer n12 = new Integer(n10);
                            IntHashtable intHashtable = (IntHashtable)this.objStmMark.get(n12);
                            if (intHashtable == null) {
                                intHashtable = new IntHashtable();
                                intHashtable.put(n9, 1);
                                this.objStmMark.put(n12, intHashtable);
                                break;
                            }
                            intHashtable.put(n9, 1);
                        }
                    }
                }
                ++n6;
            }
        }
        if ((n2 *= 2) < this.xref.length) {
            this.xref[n2] = -1;
        }
        if (n4 == -1) {
            return true;
        }
        return this.readXRefStream(n4);
    }

    protected void rebuildXref() throws IOException {
        Object object;
        int n;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(0);
        int[][] nArrayArray = new int[1024][];
        Object object2 = 0;
        this.trailer = null;
        byte[] byArray = new byte[64];
        while (true) {
            n = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(byArray)) break;
            if (byArray[0] == 116) {
                if (!PdfEncodings.convertToString(byArray, null).startsWith("trailer")) continue;
                n = this.tokens.getFilePointer();
                try {
                    object = (PdfDictionary)this.readPRObject();
                    if (object.get(PdfName.ROOT) != null) {
                        this.trailer = object;
                        continue;
                    }
                    this.tokens.seek(n);
                }
                catch (Exception exception) {
                    this.tokens.seek(n);
                }
                continue;
            }
            if (byArray[0] < 48 || byArray[0] > 57 || (object = PRTokeniser.checkObjectStart(byArray)) == null) continue;
            Object object3 = object[0];
            Object object4 = object[1];
            if (object3 >= nArrayArray.length) {
                reference var8_9 = object3 * 2;
                int[][] nArrayArray2 = new int[var8_9][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, object2);
                nArrayArray = nArrayArray2;
            }
            if (object3 >= object2) {
                object2 = object3 + true;
            }
            if (nArrayArray[object3] != null && object4 < nArrayArray[object3][1]) continue;
            object[0] = n;
            nArrayArray[object3] = object;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[object2 * 2];
        for (n = 0; n < object2; ++n) {
            object = nArrayArray[n];
            if (object == null) continue;
            this.xref[n * 2] = (int)object[0];
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue());
            PdfObject pdfObject = this.readPRObject();
            int n = pdfObject.type();
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n;
        PdfArray pdfArray = new PdfArray();
        while (-(n = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n = this.tokens.getTokenType();
        switch (n) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                int n2 = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int n3 = this.tokens.read();
                    if (n3 != 10) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition(n3);
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    pRStream.setObjNum(this.objNum, this.objGen);
                    return pRStream;
                }
                this.tokens.seek(n2);
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString pdfString = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                pdfString.setObjNum(this.objNum, this.objGen);
                if (this.strings != null) {
                    this.strings.add(pdfString);
                }
                return pdfString;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                int n4 = this.tokens.getReference();
                PRIndirectReference pRIndirectReference = new PRIndirectReference(this, n4, this.tokens.getGeneration());
                if (this.visited != null && !this.visited[n4]) {
                    this.visited[n4] = true;
                    this.newHits.put(n4, 1);
                }
                return pRIndirectReference;
            }
        }
        return new PdfLiteral(-n, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] decodePredictor(byte[] byArray, PdfObject pdfObject) {
        if (pdfObject == null || !pdfObject.isDictionary()) {
            return byArray;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.PREDICTOR));
        if (pdfObject2 == null || !pdfObject2.isNumber()) {
            return byArray;
        }
        int n = ((PdfNumber)pdfObject2).intValue();
        if (n < 10) {
            return byArray;
        }
        int n2 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLUMNS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n2 = ((PdfNumber)pdfObject2).intValue();
        }
        int n3 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLORS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n3 = ((PdfNumber)pdfObject2).intValue();
        }
        int n4 = 8;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.BITSPERCOMPONENT));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n5 = n3 * n4 / 8;
        int n6 = (n3 * n2 * n4 + 7) / 8;
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n6];
        while (true) {
            int n7 = 0;
            try {
                n7 = dataInputStream.read();
                if (n7 < 0) {
                    return byteArrayOutputStream.toByteArray();
                }
                dataInputStream.readFully(byArray2, 0, n6);
            }
            catch (Exception exception) {
                return byteArrayOutputStream.toByteArray();
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = n5; i < n6; ++i) {
                        int n8 = i;
                        byArray2[n8] = (byte)(byArray2[n8] + byArray2[i - n5]);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n6; ++i) {
                        int n9 = i;
                        byArray2[n9] = (byte)(byArray2[n9] + byArray3[i]);
                    }
                    break;
                }
                case 3: {
                    int n10;
                    for (n10 = 0; n10 < n5; ++n10) {
                        int n11 = n10;
                        byArray2[n11] = (byte)(byArray2[n11] + byArray3[n10] / 2);
                    }
                    for (n10 = n5; n10 < n6; ++n10) {
                        int n12 = n10;
                        byArray2[n12] = (byte)(byArray2[n12] + ((byArray2[n10 - n5] & 0xFF) + (byArray3[n10] & 0xFF)) / 2);
                    }
                    break;
                }
                case 4: {
                    int n13;
                    for (n13 = 0; n13 < n5; ++n13) {
                        int n14 = n13;
                        byArray2[n14] = (byte)(byArray2[n14] + byArray3[n13]);
                    }
                    n13 = n5;
                    while (n13 < n6) {
                        int n15 = byArray2[n13 - n5] & 0xFF;
                        int n16 = byArray3[n13] & 0xFF;
                        int n17 = byArray3[n13 - n5] & 0xFF;
                        int n18 = n15 + n16 - n17;
                        int n19 = Math.abs(n18 - n15);
                        int n20 = Math.abs(n18 - n16);
                        int n21 = Math.abs(n18 - n17);
                        int n22 = n19 <= n20 && n19 <= n21 ? n15 : (n20 <= n21 ? n16 : n17);
                        int n23 = n13++;
                        byArray2[n23] = (byte)(byArray2[n23] + (byte)n22);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
        }
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n;
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < byArray.length && (n = byArray[i] & 0xFF) != 62; ++i) {
            if (PRTokeniser.isWhitespace(n)) continue;
            int n3 = PRTokeniser.getHex(n);
            if (n3 == -1) {
                throw new RuntimeException("Illegal character in ASCIIHexDecode.");
            }
            if (bl) {
                n2 = n3;
            } else {
                byteArrayOutputStream.write((byte)((n2 << 4) + n3));
            }
            bl = !bl;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n2 << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int[] nArray = new int[5];
        for (n2 = 0; n2 < byArray.length && (n = byArray[n2] & 0xFF) != 126; ++n2) {
            if (PRTokeniser.isWhitespace(n)) continue;
            if (n == 122 && n3 == 0) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                continue;
            }
            if (n < 33 || n > 117) {
                throw new RuntimeException("Illegal character in ASCII85Decode.");
            }
            nArray[n3] = n - 33;
            if (++n3 != 5) continue;
            n3 = 0;
            int n4 = 0;
            for (int i = 0; i < 5; ++i) {
                n4 = n4 * 85 + nArray[i];
            }
            byteArrayOutputStream.write((byte)(n4 >> 24));
            byteArrayOutputStream.write((byte)(n4 >> 16));
            byteArrayOutputStream.write((byte)(n4 >> 8));
            byteArrayOutputStream.write((byte)n4);
        }
        n2 = 0;
        if (n3 == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (n3 == 2) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
        } else if (n3 == 3) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
        } else if (n3 == 4) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
            byteArrayOutputStream.write((byte)(n2 >> 8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int n) {
        if (n > this.pages.size()) {
            return null;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)this.pages.get(n - 1);
        if (this.appendable) {
            pdfDictionary.setIndRef((PRIndirectReference)this.pageRefs.get(n - 1));
        }
        return pdfDictionary;
    }

    public PRIndirectReference getPageOrigRef(int n) {
        if (n > this.pageRefs.size()) {
            return null;
        }
        return (PRIndirectReference)this.pageRefs.get(n - 1);
    }

    public byte[] getPageContent(int n, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageN(n);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
        if (pdfObject == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (pdfObject.isStream()) {
            return PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        if (pdfObject.isArray()) {
            PdfArray pdfArray = (PdfArray)pdfObject;
            ArrayList arrayList = pdfArray.getArrayList();
            byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < arrayList.size(); ++i) {
                PdfObject pdfObject2 = PdfReader.getPdfObject((PdfObject)arrayList.get(i));
                if (pdfObject2 == null || !pdfObject2.isStream()) continue;
                byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject2, randomAccessFileOrArray);
                byteArrayOutputStream.write(byArray);
                if (i == arrayList.size() - 1) continue;
                byteArrayOutputStream.write(10);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPageContent(int n) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = this.getPageContent(n, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void killXref(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect()) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                int n = ((PRIndirectReference)pdfObject).getNumber();
                pdfObject = (PdfObject)this.xrefObj.get(n);
                this.xrefObj.set(n, null);
                this.freeXref = n;
                this.killXref(pdfObject);
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.killXref((PdfObject)arrayList.get(i));
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    this.killXref(pdfDictionary.get((PdfName)iterator.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int n, byte[] byArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageN(n);
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(pdfObject);
        if (this.freeXref == -1) {
            this.xrefObj.add(null);
            this.freeXref = this.xrefObj.size() - 1;
        }
        pdfDictionary.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj.set(this.freeXref, new PRStream(this, byArray));
    }

    public static byte[] getStreamBytes(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        Object object;
        byte[] byArray;
        PdfReader pdfReader = pRStream.getReader();
        PdfObject pdfObject = PdfReader.getPdfObject(pRStream.get(PdfName.FILTER));
        if (pRStream.getOffset() < 0) {
            byArray = pRStream.getBytes();
        } else {
            byArray = new byte[pRStream.getLength()];
            randomAccessFileOrArray.seek(pRStream.getOffset());
            randomAccessFileOrArray.readFully(byArray);
            object = pdfReader.getDecrypt();
            if (object != null) {
                ((PdfEncryption)object).setHashKey(pRStream.getObjNum(), pRStream.getObjGen());
                ((PdfEncryption)object).prepareKey();
                ((PdfEncryption)object).encryptRC4(byArray);
            }
        }
        object = new ArrayList<PdfObject>();
        if (pdfObject != null) {
            if (pdfObject.isName()) {
                ((ArrayList)object).add(pdfObject);
            } else if (pdfObject.isArray()) {
                object = ((PdfArray)pdfObject).getArrayList();
            }
        }
        ArrayList arrayList = new ArrayList();
        PdfObject pdfObject2 = PdfReader.getPdfObject(pRStream.get(PdfName.DECODEPARMS));
        if (pdfObject2 == null || !pdfObject2.isDictionary() && !pdfObject2.isArray()) {
            pdfObject2 = PdfReader.getPdfObject(pRStream.get(PdfName.DP));
        }
        if (pdfObject2 != null) {
            if (pdfObject2.isDictionary()) {
                arrayList.add(pdfObject2);
            } else if (pdfObject2.isArray()) {
                arrayList = ((PdfArray)pdfObject2).getArrayList();
            }
        }
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            PdfObject pdfObject3;
            String string = ((PdfName)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(i))).toString();
            if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                byArray = PdfReader.FlateDecode(byArray);
                pdfObject3 = null;
                if (i >= arrayList.size()) continue;
                pdfObject3 = (PdfObject)arrayList.get(i);
                byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                continue;
            }
            if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                byArray = PdfReader.ASCIIHexDecode(byArray);
                continue;
            }
            if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                byArray = PdfReader.ASCII85Decode(byArray);
                continue;
            }
            if (string.equals("/LZWDecode")) {
                byArray = PdfReader.LZWDecode(byArray);
                pdfObject3 = null;
                if (i >= arrayList.size()) continue;
                pdfObject3 = (PdfObject)arrayList.get(i);
                byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                continue;
            }
            throw new IOException("The filter " + string + " is not supported.");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamBytes(PRStream pRStream) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = PdfReader.getStreamBytes(pRStream, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public void eliminateSharedStreams() {
        PdfObject pdfObject;
        int n;
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pages.size() == 1) {
            return;
        }
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList<PRStream> arrayList2 = new ArrayList<PRStream>();
        IntHashtable intHashtable = new IntHashtable();
        for (n = 0; n < this.pages.size(); ++n) {
            PdfObject pdfObject2;
            PdfObject pdfObject3;
            pdfObject = (PdfDictionary)this.pages.get(n);
            if (pdfObject == null || (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.CONTENTS))) == null) continue;
            if (pdfObject3.isStream()) {
                pdfObject2 = (PRIndirectReference)((PdfDictionary)pdfObject).get(PdfName.CONTENTS);
                if (intHashtable.containsKey(((PdfIndirectReference)pdfObject2).getNumber())) {
                    arrayList.add(pdfObject2);
                    arrayList2.add(new PRStream((PRStream)pdfObject3, null));
                    continue;
                }
                intHashtable.put(((PdfIndirectReference)pdfObject2).getNumber(), 1);
                continue;
            }
            pdfObject2 = (PdfArray)pdfObject3;
            ArrayList arrayList3 = ((PdfArray)pdfObject2).getArrayList();
            for (int i = 0; i < arrayList3.size(); ++i) {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)arrayList3.get(i);
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    arrayList.add(pRIndirectReference);
                    arrayList2.add(new PRStream((PRStream)PdfReader.getPdfObject(pRIndirectReference), null));
                    continue;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
            }
        }
        if (arrayList2.size() == 0) {
            return;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.xrefObj.add(arrayList2.get(n));
            pdfObject = (PRIndirectReference)arrayList.get(n);
            ((PRIndirectReference)pdfObject).setNumber(this.xrefObj.size() - 1, 0);
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean bl) {
        this.tampered = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMetadata() throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(pdfObject instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        byte[] byArray = null;
        try {
            randomAccessFileOrArray.reOpen();
            byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.xrefObj.size();
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static boolean existsName(PdfDictionary pdfDictionary, PdfName pdfName, PdfName pdfName2) {
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
        if (pdfObject == null || !pdfObject.isName()) {
            return false;
        }
        PdfName pdfName3 = (PdfName)pdfObject;
        return pdfName3.equals(pdfName2);
    }

    static String getFontName(PdfDictionary pdfDictionary) {
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.BASEFONT));
        if (pdfObject == null || !pdfObject.isName()) {
            return null;
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    static String getSubsetPrefix(PdfDictionary pdfDictionary) {
        String string = PdfReader.getFontName(pdfDictionary);
        if (string == null) {
            return null;
        }
        if (string.length() < 8 || string.charAt(6) != '+') {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            return null;
        }
        return string;
    }

    public int shuffleSubsetNames() {
        int n = 0;
        for (int i = 1; i < this.xrefObj.size(); ++i) {
            String string;
            PdfDictionary pdfDictionary;
            Object object;
            Object object2;
            String string2;
            PdfDictionary pdfDictionary2;
            PdfObject pdfObject = (PdfObject)this.xrefObj.get(i);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfReader.existsName(pdfDictionary2 = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT)) continue;
            if (PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                string2 = PdfReader.getSubsetPrefix(pdfDictionary2);
                if (string2 == null) continue;
                object2 = BaseFont.createSubsetPrefix() + string2.substring(7);
                object = new PdfName((String)object2);
                pdfDictionary2.put(PdfName.BASEFONT, (PdfObject)object);
                ++n;
                pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FONTDESCRIPTOR));
                if (pdfDictionary == null) continue;
                pdfDictionary.put(PdfName.FONTNAME, (PdfObject)object);
                continue;
            }
            if (!PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.TYPE0)) continue;
            string2 = PdfReader.getSubsetPrefix(pdfDictionary2);
            object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.DESCENDANTFONTS));
            if (object2 == null || ((ArrayList)(object = ((PdfArray)object2).getArrayList())).size() == 0 || (string = PdfReader.getSubsetPrefix(pdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(0)))) == null) continue;
            String string3 = BaseFont.createSubsetPrefix();
            if (string2 != null) {
                pdfDictionary2.put(PdfName.BASEFONT, new PdfName(string3 + string2.substring(7)));
            }
            PdfName pdfName = new PdfName(string3 + string.substring(7));
            pdfDictionary.put(PdfName.BASEFONT, pdfName);
            ++n;
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
            if (pdfDictionary3 == null) continue;
            pdfDictionary3.put(PdfName.FONTNAME, pdfName);
        }
        return n;
    }

    public int createFakeFontSubsets() {
        int n = 0;
        for (int i = 1; i < this.xrefObj.size(); ++i) {
            String string;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = (PdfObject)this.xrefObj.get(i);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfReader.existsName(pdfDictionary = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT) || !PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE1) && !PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.MMTYPE1) && !PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TRUETYPE) || (string = PdfReader.getSubsetPrefix(pdfDictionary)) != null || (string = PdfReader.getFontName(pdfDictionary)) == null) continue;
            String string2 = BaseFont.createSubsetPrefix() + string;
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
            if (pdfDictionary2 == null || pdfDictionary2.get(PdfName.FONTFILE) == null && pdfDictionary2.get(PdfName.FONTFILE2) == null && pdfDictionary2.get(PdfName.FONTFILE3) == null) continue;
            PdfName pdfName = new PdfName(string2);
            pdfDictionary.put(PdfName.BASEFONT, pdfName);
            pdfDictionary2.put(PdfName.FONTNAME, pdfName);
            ++n;
        }
        return n;
    }

    private static PdfArray getNameArray(PdfObject pdfObject) {
        PdfObject pdfObject2;
        if (pdfObject == null) {
            return null;
        }
        if ((pdfObject = PdfReader.getPdfObject(pdfObject)).isArray()) {
            return (PdfArray)pdfObject;
        }
        if (pdfObject.isDictionary() && (pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.D))) != null && pdfObject2.isArray()) {
            return (PdfArray)pdfObject2;
        }
        return null;
    }

    public HashMap getNamedDestination() {
        HashMap hashMap = this.getNamedDestinationFromNames();
        hashMap.putAll(this.getNamedDestinationFromStrings());
        return hashMap;
    }

    public HashMap getNamedDestinationFromNames() {
        HashMap<String, PdfArray> hashMap = new HashMap<String, PdfArray>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.DESTS));
            Set set = pdfDictionary.getKeys();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PdfName pdfName = (PdfName)iterator.next();
                String string = PdfName.decodeName(pdfName.toString());
                PdfArray pdfArray = PdfReader.getNameArray(pdfDictionary.get(pdfName));
                if (pdfArray == null) continue;
                hashMap.put(string, pdfArray);
            }
        }
        return hashMap;
    }

    public HashMap getNamedDestinationFromStrings() {
        if (this.catalog.get(PdfName.NAMES) != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.NAMES));
            if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESTS))) != null) {
                HashMap hashMap = PdfNameTree.readTree(pdfDictionary);
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    PdfArray pdfArray = PdfReader.getNameArray((PdfObject)entry.getValue());
                    if (pdfArray != null) {
                        entry.setValue(pdfArray);
                        continue;
                    }
                    iterator.remove();
                }
                return hashMap;
            }
        }
        return new HashMap();
    }

    private static void replaceNamedDestination(PdfObject pdfObject, HashMap hashMap) {
        if (pdfObject != null && pdfObject.isDictionary()) {
            PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.DEST));
            String string = null;
            if (pdfObject2 != null) {
                if (pdfObject2.isName()) {
                    string = PdfName.decodeName(pdfObject2.toString());
                } else if (pdfObject2.isString()) {
                    string = pdfObject2.toString();
                }
                PdfArray pdfArray = (PdfArray)hashMap.get(string);
                if (pdfArray != null) {
                    ((PdfDictionary)pdfObject).put(PdfName.DEST, pdfArray);
                }
            } else {
                PdfDictionary pdfDictionary;
                PdfName pdfName;
                pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.A));
                if (pdfObject2 != null && PdfName.GOTO.equals(pdfName = (PdfName)PdfReader.getPdfObject((pdfDictionary = (PdfDictionary)pdfObject2).get(PdfName.S)))) {
                    pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.D));
                    if (pdfObject2.isName()) {
                        string = PdfName.decodeName(pdfObject2.toString());
                    } else if (pdfObject2.isString()) {
                        string = pdfObject2.toString();
                    }
                    PdfArray pdfArray = (PdfArray)hashMap.get(string);
                    if (pdfArray != null) {
                        pdfDictionary.put(PdfName.D, pdfArray);
                    }
                }
            }
        }
    }

    public void removeFields() {
        for (int i = 0; i < this.pages.size(); ++i) {
            PdfDictionary pdfDictionary = (PdfDictionary)this.pages.get(i);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            if (pdfArray == null) continue;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int j = 0; j < arrayList.size(); ++j) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(j));
                if (!PdfName.WIDGET.equals(pdfDictionary2.get(PdfName.SUBTYPE))) continue;
                arrayList.remove(j--);
            }
            if (!arrayList.isEmpty()) continue;
            pdfDictionary.remove(PdfName.ANNOTS);
        }
        this.catalog.remove(PdfName.ACROFORM);
    }

    public void removeAnnotations() {
        for (int i = 0; i < this.pages.size(); ++i) {
            ((PdfDictionary)this.pages.get(i)).remove(PdfName.ANNOTS);
        }
        this.catalog.remove(PdfName.ACROFORM);
    }

    private void iterateBookmarks(PdfDictionary pdfDictionary, HashMap hashMap) {
        while (pdfDictionary != null) {
            PdfReader.replaceNamedDestination(pdfDictionary, hashMap);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIRST));
            if (pdfDictionary2 != null) {
                this.iterateBookmarks(pdfDictionary2, hashMap);
            }
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NEXT));
        }
    }

    public void consolidateNamedDestinations() {
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap hashMap = this.getNamedDestination();
        if (hashMap.size() == 0) {
            return;
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)this.pages.get(i)).get(PdfName.ANNOTS));
            if (pdfArray == null) continue;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int j = 0; j < arrayList.size(); ++j) {
                PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(j));
                PdfReader.replaceNamedDestination(pdfObject, hashMap);
            }
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.OUTLINES));
        if (pdfDictionary == null) {
            return;
        }
        this.iterateBookmarks((PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIRST)), hashMap);
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfReader pdfReader) {
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            pdfDictionary2.put(pdfName, PdfReader.duplicatePdfObject(pdfDictionary.get(pdfName), pdfReader));
        }
        return pdfDictionary2;
    }

    protected static PdfObject duplicatePdfObject(PdfObject pdfObject, PdfReader pdfReader) {
        if (pdfObject == null) {
            return null;
        }
        switch (pdfObject.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)pdfObject, null, pdfReader);
            }
            case 7: {
                PRStream pRStream = (PRStream)pdfObject;
                PRStream pRStream2 = new PRStream(pRStream, null, pdfReader);
                PdfReader.duplicatePdfDictionary(pRStream, pRStream2, pdfReader);
                return pRStream2;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                PdfArray pdfArray = new PdfArray();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    pdfArray.add(PdfReader.duplicatePdfObject((PdfObject)iterator.next(), pdfReader));
                }
                return pdfArray;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                return new PRIndirectReference(pdfReader, pRIndirectReference.getNumber(), pRIndirectReference.getGeneration());
            }
        }
        return pdfObject;
    }

    protected void removeUnusedNode(PdfObject pdfObject, boolean[] blArray) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    int n;
                    PdfName pdfName = (PdfName)iterator.next();
                    PdfObject pdfObject2 = pdfDictionary.get(pdfName);
                    if (pdfObject2.isIndirect() && ((n = ((PRIndirectReference)pdfObject2).getNumber()) >= this.xrefObj.size() || this.xrefObj.get(n) == null)) {
                        pdfDictionary.put(pdfName, PdfNull.PDFNULL);
                        continue;
                    }
                    this.removeUnusedNode(pdfObject2, blArray);
                }
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n;
                    PdfObject pdfObject3 = (PdfObject)arrayList.get(i);
                    if (pdfObject3.isIndirect() && this.xrefObj.get(n = ((PRIndirectReference)pdfObject3).getNumber()) == null) {
                        arrayList.set(i, PdfNull.PDFNULL);
                        continue;
                    }
                    this.removeUnusedNode(pdfObject3, blArray);
                }
                break;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                int n = pRIndirectReference.getNumber();
                if (blArray[n]) break;
                blArray[n] = true;
                this.removeUnusedNode(PdfReader.getPdfObject(pRIndirectReference), blArray);
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] blArray = new boolean[this.xrefObj.size()];
        this.removeUnusedNode(this.trailer, blArray);
        int n = 0;
        for (int i = 1; i < blArray.length; ++i) {
            if (blArray[i] || this.xrefObj.get(i) == null) continue;
            this.xrefObj.set(i, null);
            ++n;
        }
        return n;
    }

    public AcroFields getAcroFields() {
        return new AcroFields(this, null);
    }

    public String getJavaScript(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.NAMES));
        if (pdfDictionary == null) {
            return null;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.JAVASCRIPT));
        if (pdfDictionary2 == null) {
            return null;
        }
        HashMap hashMap = PdfNameTree.readTree(pdfDictionary2);
        String[] stringArray = new String[hashMap.size()];
        stringArray = hashMap.keySet().toArray(stringArray);
        Arrays.sort(stringArray, new StringCompare());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PdfIndirectReference)hashMap.get(stringArray[i]));
            if (pdfDictionary3 == null) continue;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary3.get(PdfName.JS));
            if (pdfObject.isString()) {
                stringBuffer.append(((PdfString)pdfObject).toUnicodeString()).append('\n');
                continue;
            }
            if (!pdfObject.isStream()) continue;
            byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
            if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                stringBuffer.append(PdfEncodings.convertToString(byArray, "UnicodeBig"));
            } else {
                stringBuffer.append(PdfEncodings.convertToString(byArray, "PDF"));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaScript() throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            String string = this.getJavaScript(randomAccessFileOrArray);
            return string;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public void selectPages(String string) {
        this.selectPages(SequenceList.expand(string, this.getNumberOfPages()));
    }

    public void selectPages(List list) {
        int n;
        Object object;
        IntHashtable intHashtable = new IntHashtable();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (Integer)object2.next();
            int n2 = (Integer)object;
            if (n2 < 1 || n2 > this.pages.size() || intHashtable.put(n2, 1) != 0) continue;
            arrayList.add(object);
        }
        object2 = (PRIndirectReference)this.catalog.get(PdfName.PAGES);
        object = (PdfDictionary)PdfReader.getPdfObject((PdfObject)object2);
        PRIndirectReference[] pRIndirectReferenceArray = new PRIndirectReference[arrayList.size()];
        PdfDictionary[] pdfDictionaryArray = new PdfDictionary[arrayList.size()];
        ((PdfDictionary)object).put(PdfName.COUNT, new PdfNumber(arrayList.size()));
        PdfArray pdfArray = new PdfArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            n = (Integer)arrayList.get(i) - 1;
            pRIndirectReferenceArray[i] = (PRIndirectReference)this.pageRefs.get(n);
            pdfArray.add(pRIndirectReferenceArray[i]);
            pdfDictionaryArray[i] = (PdfDictionary)this.pages.get(n);
            pdfDictionaryArray[i].put(PdfName.PARENT, (PdfObject)object2);
            this.pageRefs.set(n, null);
        }
        ((PdfDictionary)object).put(PdfName.KIDS, pdfArray);
        AcroFields acroFields = this.getAcroFields();
        for (n = 0; n < this.pageRefs.size(); ++n) {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)this.pageRefs.get(n);
            if (pRIndirectReference == null) continue;
            acroFields.removeFieldsFromPage(n + 1);
            this.xrefObj.set(pRIndirectReference.getNumber(), null);
        }
        this.pages = new ArrayList<PdfDictionary>(Arrays.asList(pdfDictionaryArray));
        this.pageRefs = new ArrayList<PRIndirectReference>(Arrays.asList(pRIndirectReferenceArray));
        this.removeUnusedObjects();
    }

    public static void setViewerPreferences(int n, PdfDictionary pdfDictionary) {
        pdfDictionary.remove(PdfName.PAGELAYOUT);
        pdfDictionary.remove(PdfName.PAGEMODE);
        pdfDictionary.remove(PdfName.VIEWERPREFERENCES);
        if ((n & 1) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.SINGLEPAGE);
        } else if ((n & 2) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.ONECOLUMN);
        } else if ((n & 4) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNLEFT);
        } else if ((n & 8) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNRIGHT);
        }
        if ((n & 0x10) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USENONE);
        } else if ((n & 0x20) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
        } else if ((n & 0x40) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USETHUMBS);
        } else if ((n & 0x80) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.FULLSCREEN);
        } else if ((n & 0x100000) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USEOC);
        }
        if ((n & 0xFFF00) == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if ((n & 0x100) != 0) {
            pdfDictionary2.put(PdfName.HIDETOOLBAR, PdfBoolean.PDFTRUE);
        }
        if ((n & 0x200) != 0) {
            pdfDictionary2.put(PdfName.HIDEMENUBAR, PdfBoolean.PDFTRUE);
        }
        if ((n & 0x400) != 0) {
            pdfDictionary2.put(PdfName.HIDEWINDOWUI, PdfBoolean.PDFTRUE);
        }
        if ((n & 0x800) != 0) {
            pdfDictionary2.put(PdfName.FITWINDOW, PdfBoolean.PDFTRUE);
        }
        if ((n & 0x1000) != 0) {
            pdfDictionary2.put(PdfName.CENTERWINDOW, PdfBoolean.PDFTRUE);
        }
        if ((n & 0x40000) != 0) {
            pdfDictionary2.put(PdfName.DISPLAYDOCTITLE, PdfBoolean.PDFTRUE);
        }
        if ((n & 0x2000) != 0) {
            pdfDictionary2.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USENONE);
        } else if ((n & 0x4000) != 0) {
            pdfDictionary2.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOUTLINES);
        } else if ((n & 0x8000) != 0) {
            pdfDictionary2.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USETHUMBS);
        } else if ((n & 0x80000) != 0) {
            pdfDictionary2.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOC);
        }
        if ((n & 0x10000) != 0) {
            pdfDictionary2.put(PdfName.DIRECTION, PdfName.L2R);
        } else if ((n & 0x20000) != 0) {
            pdfDictionary2.put(PdfName.DIRECTION, PdfName.R2L);
        }
        pdfDictionary.put(PdfName.VIEWERPREFERENCES, pdfDictionary2);
    }

    public void setViewerPreferences(int n) {
        PdfReader.setViewerPreferences(n, this.catalog);
    }

    public int getViewerPreferences() {
        int n = 0;
        PdfName pdfName = null;
        PdfObject pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.PAGELAYOUT));
        if (pdfObject != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
            if (pdfName.equals(PdfName.SINGLEPAGE)) {
                n |= 1;
            } else if (pdfName.equals(PdfName.ONECOLUMN)) {
                n |= 2;
            } else if (pdfName.equals(PdfName.TWOCOLUMNLEFT)) {
                n |= 4;
            } else if (pdfName.equals(PdfName.TWOCOLUMNRIGHT)) {
                n |= 8;
            }
        }
        if ((pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.PAGEMODE))) != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
            if (pdfName.equals(PdfName.USENONE)) {
                n |= 0x10;
            } else if (pdfName.equals(PdfName.USEOUTLINES)) {
                n |= 0x20;
            } else if (pdfName.equals(PdfName.USETHUMBS)) {
                n |= 0x40;
            } else if (pdfName.equals(PdfName.USEOC)) {
                n |= 0x100000;
            }
        }
        if ((pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.VIEWERPREFERENCES))) == null || !pdfObject.isDictionary()) {
            return n;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        for (int i = 0; i < vpnames.length; ++i) {
            pdfObject = PdfReader.getPdfObject(this.catalog.get(vpnames[i]));
            if (pdfObject == null || !"true".equals(pdfObject.toString())) continue;
            n |= vpints[i];
        }
        pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.NONFULLSCREENPAGEMODE));
        if (pdfObject != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
            if (pdfName.equals(PdfName.USENONE)) {
                n |= 0x2000;
            } else if (pdfName.equals(PdfName.USEOUTLINES)) {
                n |= 0x4000;
            } else if (pdfName.equals(PdfName.USETHUMBS)) {
                n |= 0x8000;
            } else if (pdfName.equals(PdfName.USEOC)) {
                n |= 0x80000;
            }
        }
        if ((pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.DIRECTION))) != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
            if (pdfName.equals(PdfName.L2R)) {
                n |= 0x10000;
            } else if (pdfName.equals(PdfName.R2L)) {
                n |= 0x20000;
            }
        }
        return n;
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    public void setAppendable(boolean bl) {
        this.appendable = bl;
        if (bl) {
            PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        }
    }

    public boolean isNewXrefType() {
        return this.newXrefType;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public boolean isHybridXref() {
        return this.hybridXref;
    }
}

