/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Reference propertyTypeRef;
    private Reference readMethodRef;
    private Reference writeMethodRef;
    private Reference propertyEditorClassRef;
    private boolean bound;
    private boolean constrained;
    private String baseName;
    private String writeMethodName;
    private String readMethodName;

    public PropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        this(string, clazz, "is" + FeatureDescriptor.capitalize(string), "set" + FeatureDescriptor.capitalize(string));
    }

    public PropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        if (clazz == null) {
            throw new IntrospectionException("Target Bean class is null");
        }
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        if ("".equals(string2) || "".equals(string3)) {
            throw new IntrospectionException("read or write method name should not be the empty string");
        }
        this.setName(string);
        this.setClass0(clazz);
        this.readMethodName = string2;
        if (string2 != null && this.getReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + string2);
        }
        this.writeMethodName = string3;
        if (string3 != null && this.getWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + string3);
        }
    }

    public PropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        this.setName(string);
        this.setReadMethod(method);
        this.setWriteMethod(method2);
    }

    public Class getPropertyType() {
        Class clazz = this.getPropertyType0();
        if (clazz == null) {
            try {
                clazz = this.findPropertyType(this.getReadMethod(), this.getWriteMethod());
                this.setPropertyType(clazz);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private void setPropertyType(Class clazz) {
        this.propertyTypeRef = FeatureDescriptor.createReference(clazz);
    }

    private Class getPropertyType0() {
        return (Class)FeatureDescriptor.getObject(this.propertyTypeRef);
    }

    public Method getReadMethod() {
        Method method = this.getReadMethod0();
        if (method == null) {
            Class clazz = this.getClass0();
            if (clazz == null || this.readMethodName == null && this.readMethodRef == null) {
                return null;
            }
            if (this.readMethodName == null) {
                Class clazz2 = this.getPropertyType0();
                this.readMethodName = clazz2 == Boolean.TYPE || clazz2 == null ? "is" + this.getBaseName() : "get" + this.getBaseName();
            }
            try {
                method = Introspector.findMethod(clazz, this.readMethodName, 0);
            }
            catch (Exception exception) {
                method = null;
            }
            if (method == null) {
                this.readMethodName = "get" + this.getBaseName();
                try {
                    method = Introspector.findMethod(clazz, this.readMethodName, 0);
                }
                catch (Exception exception) {
                    method = null;
                }
            }
            try {
                this.setReadMethod(method);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return method;
    }

    public void setReadMethod(Method method) throws IntrospectionException {
        if (method == null) {
            this.readMethodName = null;
            this.readMethodRef = null;
            return;
        }
        this.setPropertyType(this.findPropertyType(method, this.getWriteMethod0()));
        this.setClass0(method.getDeclaringClass());
        this.readMethodName = method.getName();
        this.readMethodRef = FeatureDescriptor.createReference(method, true);
    }

    public Method getWriteMethod() {
        Method method = this.getWriteMethod0();
        if (method == null) {
            Class clazz = this.getClass0();
            if (clazz == null || this.writeMethodName == null && this.writeMethodRef == null) {
                return null;
            }
            Class clazz2 = this.getPropertyType0();
            if (clazz2 == null) {
                try {
                    clazz2 = this.findPropertyType(this.getReadMethod(), null);
                    this.setPropertyType(clazz2);
                }
                catch (IntrospectionException introspectionException) {
                    return null;
                }
            }
            if (this.writeMethodName == null) {
                this.writeMethodName = "set" + this.getBaseName();
            }
            try {
                Class[] classArray;
                if (clazz2 == null) {
                    classArray = null;
                } else {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = clazz2;
                }
                method = Introspector.findMethod(clazz, this.writeMethodName, 1, classArray);
            }
            catch (Exception exception) {
                method = null;
            }
            try {
                this.setWriteMethod(method);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return method;
    }

    public void setWriteMethod(Method method) throws IntrospectionException {
        if (method == null) {
            this.writeMethodName = null;
            this.writeMethodRef = null;
            return;
        }
        this.setPropertyType(this.findPropertyType(this.getReadMethod(), method));
        this.setClass0(method.getDeclaringClass());
        this.writeMethodName = method.getName();
        this.writeMethodRef = FeatureDescriptor.createReference(method, true);
    }

    private Method getReadMethod0() {
        return (Method)FeatureDescriptor.getObject(this.readMethodRef);
    }

    private Method getWriteMethod0() {
        return (Method)FeatureDescriptor.getObject(this.writeMethodRef);
    }

    void setClass0(Class clazz) {
        if (this.getClass0() != null && clazz.isAssignableFrom(this.getClass0())) {
            return;
        }
        super.setClass0(clazz);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bl) {
        this.bound = bl;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean bl) {
        this.constrained = bl;
    }

    public void setPropertyEditorClass(Class clazz) {
        if (clazz == null) {
            this.propertyEditorClassRef = null;
            return;
        }
        this.propertyEditorClassRef = new WeakReference(clazz);
    }

    public Class getPropertyEditorClass() {
        if (this.propertyEditorClassRef == null) {
            return null;
        }
        return (Class)this.propertyEditorClassRef.get();
    }

    boolean compareMethods(Method method, Method method2) {
        if (method == null != (method2 == null)) {
            return false;
        }
        return method == null || method2 == null || method.equals(method2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            if (!this.compareMethods(this.getReadMethod(), method)) {
                return false;
            }
            if (!this.compareMethods(this.getWriteMethod(), method2)) {
                return false;
            }
            if (this.getPropertyType() == propertyDescriptor.getPropertyType() && this.getPropertyEditorClass() == propertyDescriptor.getPropertyEditorClass() && this.bound == propertyDescriptor.isBound() && this.constrained == propertyDescriptor.isConstrained() && this.writeMethodName == propertyDescriptor.writeMethodName && this.readMethodName == propertyDescriptor.readMethodName) {
                return true;
            }
        }
        return false;
    }

    PropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        this.baseName = propertyDescriptor2.baseName != null ? propertyDescriptor2.baseName : propertyDescriptor.baseName;
        this.readMethodName = propertyDescriptor2.readMethodName != null ? propertyDescriptor2.readMethodName : propertyDescriptor.readMethodName;
        this.writeMethodName = propertyDescriptor2.writeMethodName != null ? propertyDescriptor2.writeMethodName : propertyDescriptor.writeMethodName;
        this.propertyTypeRef = propertyDescriptor2.propertyTypeRef != null ? propertyDescriptor2.propertyTypeRef : propertyDescriptor.propertyTypeRef;
        Method method = propertyDescriptor.getReadMethod();
        Method method2 = propertyDescriptor2.getReadMethod();
        try {
            if (method2 != null && method2.getDeclaringClass() == this.getClass0()) {
                this.setReadMethod(method2);
            } else {
                this.setReadMethod(method);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (method != null && method2 != null && method.getDeclaringClass() == method2.getDeclaringClass() && method.getReturnType() == Boolean.TYPE && method2.getReturnType() == Boolean.TYPE && method.getName().indexOf("is") == 0 && method2.getName().indexOf("get") == 0) {
            try {
                this.setReadMethod(method);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        Method method3 = propertyDescriptor.getWriteMethod();
        Method method4 = propertyDescriptor2.getWriteMethod();
        try {
            if (method4 != null && method4.getDeclaringClass() == this.getClass0()) {
                this.setWriteMethod(method4);
            } else {
                this.setWriteMethod(method3);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (propertyDescriptor2.getPropertyEditorClass() != null) {
            this.setPropertyEditorClass(propertyDescriptor2.getPropertyEditorClass());
        } else {
            this.setPropertyEditorClass(propertyDescriptor.getPropertyEditorClass());
        }
        this.bound = propertyDescriptor.bound | propertyDescriptor2.bound;
        this.constrained = propertyDescriptor.constrained | propertyDescriptor2.constrained;
    }

    PropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        super(propertyDescriptor);
        this.propertyTypeRef = propertyDescriptor.propertyTypeRef;
        this.readMethodRef = propertyDescriptor.readMethodRef;
        this.writeMethodRef = propertyDescriptor.writeMethodRef;
        this.propertyEditorClassRef = propertyDescriptor.propertyEditorClassRef;
        this.writeMethodName = propertyDescriptor.writeMethodName;
        this.readMethodName = propertyDescriptor.readMethodName;
        this.baseName = propertyDescriptor.baseName;
        this.bound = propertyDescriptor.bound;
        this.constrained = propertyDescriptor.constrained;
    }

    private Class findPropertyType(Method method, Method method2) throws IntrospectionException {
        Class[] classArray;
        Class clazz = null;
        if (method != null) {
            classArray = method.getParameterTypes();
            if (classArray.length != 0) {
                throw new IntrospectionException("bad read method arg count: " + method);
            }
            clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                throw new IntrospectionException("read method " + method.getName() + " returns void");
            }
        }
        if (method2 != null) {
            classArray = method2.getParameterTypes();
            if (classArray.length != 1) {
                throw new IntrospectionException("bad write method arg count: " + method2);
            }
            if (clazz != null && clazz != classArray[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            clazz = classArray[0];
        }
        return clazz;
    }

    String getBaseName() {
        if (this.baseName == null) {
            this.baseName = FeatureDescriptor.capitalize(this.getName());
        }
        return this.baseName;
    }
}

