/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.NamedWeakReference;
import java.util.Vector;
import javax.naming.NamingException;

public final class FactoryEnumeration {
    private Vector vec;
    private int posn = 0;
    private ClassLoader loader;

    FactoryEnumeration(Vector vector, ClassLoader classLoader) {
        this.vec = vector;
        this.loader = classLoader;
    }

    public Object next() throws NamingException {
        Vector vector = this.vec;
        synchronized (vector) {
            NamedWeakReference namedWeakReference = (NamedWeakReference)this.vec.elementAt(this.posn++);
            Object object = namedWeakReference.get();
            if (object != null && !(object instanceof Class)) {
                Object object2 = object;
                return object2;
            }
            String string = namedWeakReference.getName();
            try {
                if (object == null) {
                    object = Class.forName(string, true, this.loader);
                }
                object = ((Class)object).newInstance();
                namedWeakReference = new NamedWeakReference(object, string);
                this.vec.setElementAt(namedWeakReference, this.posn - 1);
                Object object3 = object;
                return object3;
            }
            catch (ClassNotFoundException classNotFoundException) {
                NamingException namingException = new NamingException("No longer able to load " + string);
                namingException.setRootCause(classNotFoundException);
                throw namingException;
            }
            catch (InstantiationException instantiationException) {
                NamingException namingException = new NamingException("Cannot instantiate " + object);
                namingException.setRootCause(instantiationException);
                throw namingException;
            }
            catch (IllegalAccessException illegalAccessException) {
                NamingException namingException = new NamingException("Cannot access " + object);
                namingException.setRootCause(illegalAccessException);
                throw namingException;
            }
        }
    }

    public boolean hasMore() {
        return this.posn < this.vec.size();
    }
}

