/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class EncryptedPrivateKeyInfo {
    private AlgorithmId algid;
    private byte[] encryptedData;
    private byte[] encoded;

    public EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        DerValue derValue = new DerValue(byArray);
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new IOException("overrun, bytes = " + derValue.data.available());
        }
        this.algid = AlgorithmId.parse(derValueArray[0]);
        if (derValueArray[0].data.available() != 0) {
            throw new IOException("encryptionAlgorithm field overrun");
        }
        this.encryptedData = derValueArray[1].getOctetString();
        if (derValueArray[1].data.available() != 0) {
            throw new IOException("encryptedData field overrun");
        }
        this.encoded = (byte[])byArray.clone();
    }

    public EncryptedPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.algid = algorithmId;
        this.encryptedData = (byte[])byArray.clone();
    }

    public AlgorithmId getAlgorithm() {
        return this.algid;
    }

    public byte[] getEncryptedData() {
        return (byte[])this.encryptedData.clone();
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.algid.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.encryptedData);
        derOutputStream.write((byte)48, derOutputStream2);
        this.encoded = derOutputStream.toByteArray();
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EncryptedPrivateKeyInfo)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((EncryptedPrivateKeyInfo)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.encryptedData.length) {
            n += this.encryptedData[n2] * n2;
            ++n2;
        }
        return n;
    }
}

