/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.iiop.DeleteConn;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.IIOPInputStream;
import com.sun.corba.se.internal.util.Utility;
import java.io.IOException;
import java.io.InputStream;

final class ReaderThread
extends Thread {
    private boolean debug;
    private boolean keepRunning = true;
    private IIOPConnection c;

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public ReaderThread(ThreadGroup threadGroup, IIOPConnection iIOPConnection, String string, boolean bl) {
        super(threadGroup, string);
        this.c = iIOPConnection;
    }

    public ReaderThread(IIOPConnection iIOPConnection, String string, boolean bl) {
        super(string);
        this.c = iIOPConnection;
    }

    public IIOPConnection getCurrentConnection() {
        return this.c;
    }

    public void run() {
        while (this.keepRunning) {
            try {
                IIOPInputStream iIOPInputStream = null;
                try {
                    iIOPInputStream = this.c.createInputStream();
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        this.dprint("IOException in createInputStream: " + iOException);
                        iOException.printStackTrace();
                    }
                    this.c.purge_calls(1, true, false);
                    this.keepRunning = false;
                }
                this.c.processInput(iIOPInputStream);
            }
            catch (DeleteConn deleteConn) {
                if (this.debug) {
                    this.dprint("DeleteConn thrown while reading request: " + deleteConn);
                    deleteConn.printStackTrace();
                }
                this.c.purge_calls(deleteConn.minorCode, true, false);
                this.keepRunning = false;
            }
            catch (ThreadDeath threadDeath) {
                if (this.debug) {
                    this.dprint("ThreadDeath thrown while reading request: " + threadDeath);
                    threadDeath.printStackTrace();
                }
                try {
                    this.c.purge_calls(1, false, false);
                    this.keepRunning = false;
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    throw threadDeath;
                }
                throw threadDeath;
            }
            catch (Exception exception) {
                if (!this.debug) break;
                this.dprint("Exception thrown while reading request: " + exception);
                exception.printStackTrace();
                break;
            }
        }
    }

    synchronized void shutdown() {
        this.keepRunning = false;
        try {
            InputStream inputStream = this.c.getInputStream();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }
}

