/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BufferedReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = reader;
        this.cb = new char[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                    this.markedChar = 0;
                    n2 = n;
                } else {
                    char[] cArray = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                    this.cb = cArray;
                    this.markedChar = 0;
                    n2 = n;
                }
                this.nextChar = this.nChars = n;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        int n = -1;
                        return n;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (this.cb[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            char c = this.cb[this.nextChar++];
            return c;
        }
    }

    private int read1(char[] cArray, int n, int n2) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (n2 >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                return this.in.read(cArray, n, n2);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cb[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n3 = Math.min(n2, this.nChars - this.nextChar);
        System.arraycopy(this.cb, this.nextChar, cArray, n, n3);
        this.nextChar += n3;
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = this.lock;
        synchronized (var4_4) {
            this.ensureOpen();
            if (var2_2 < 0 || var2_2 > var1_1.length || var3_3 < 0 || var2_2 + var3_3 > var1_1.length || var2_2 + var3_3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (var3_3 == 0) {
                var5_5 = 0;
                return var5_5;
            }
            var5_6 = this.read1(var1_1, var2_2, var3_3);
            if (var5_6 > 0) ** GOTO lbl16
            var6_7 = var5_6;
            return var6_7;
            while ((var7_8 = this.read1(var1_1, var2_2 + var5_6, var3_3 - var5_6)) > 0) {
                var5_6 += var7_8;
lbl16:
                // 2 sources

                if (var5_6 < var3_3 && this.in.ready()) continue;
            }
            var7_8 = var5_6;
            return var7_8;
        }
    }

    String readLine(boolean bl) throws IOException {
        StringBuffer stringBuffer = null;
        boolean bl2 = bl || this.skipLF;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (stringBuffer != null && stringBuffer.length() > 0) {
                        String string = stringBuffer.toString();
                        return string;
                    }
                    String string = null;
                    return string;
                }
                boolean bl3 = false;
                char c = '\u0000';
                if (!bl2 || this.cb[this.nextChar] == '\n') {
                    // empty if block
                }
                this.skipLF = false;
                bl2 = false;
                int n = ++this.nextChar;
                while (n < this.nChars) {
                    c = this.cb[n];
                    if (c == '\n' || c == '\r') {
                        bl3 = true;
                        break;
                    }
                    ++n;
                }
                int n2 = this.nextChar;
                this.nextChar = n;
                if (bl3) {
                    String string;
                    if (stringBuffer == null) {
                        string = new String(this.cb, n2, n - n2);
                    } else {
                        stringBuffer.append(this.cb, n2, n - n2);
                        string = stringBuffer.toString();
                    }
                    ++this.nextChar;
                    if (c == '\r') {
                        this.skipLF = true;
                    }
                    String string2 = string;
                    return string2;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(defaultExpectedLineLength);
                }
                stringBuffer.append(this.cb, n2, n - n2);
            }
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            long l2;
            this.ensureOpen();
            long l3 = l;
            while (l3 > 0L) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (l3 <= (l2 = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + l3);
                    l3 = 0L;
                    break;
                }
                l3 -= l2;
                this.nextChar = this.nChars;
            }
            l2 = l - l3;
            return l2;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            boolean bl = this.nextChar < this.nChars || this.in.ready();
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = n;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
        }
    }
}

