/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import java.awt.image.BufferedImage;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;

class CMMImageLayout {
    private static final int typeBase = 256;
    public static final int typeComponentUByte = 256;
    public static final int typeComponentUShort12 = 257;
    public static final int typeComponentUShort = 258;
    public static final int typePixelUByte = 259;
    public static final int typePixelUShort12 = 260;
    public static final int typePixelUShort = 261;
    public static final int typeShort555 = 262;
    public static final int typeShort565 = 263;
    public static final int typeInt101010 = 264;
    public int Type;
    public int NumCols;
    public int NumRows;
    public int OffsetColumn;
    public int OffsetRow;
    public int NumChannels;
    public Object[] chanData;
    public int[] DataOffsets;

    public CMMImageLayout(int n) {
        this.chanData = new Object[n];
    }

    CMMImageLayout(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.Type = 259;
                break;
            }
            case 2: {
                this.Type = 261;
                break;
            }
            default: {
                throw new IllegalArgumentException("more than 2 bytes per component");
            }
        }
        this.chanData = new Object[1];
        this.NumCols = n;
        this.NumRows = 1;
        this.OffsetColumn = n2 * n3;
        this.OffsetRow = this.NumCols * this.OffsetColumn;
        this.NumChannels = n2;
        this.DataOffsets = new int[this.NumChannels];
    }

    CMMImageLayout(BufferedImage bufferedImage) {
        this.Type = bufferedImage.getType();
        switch (this.Type) {
            case 1: 
            case 2: 
            case 3: {
                this.NumChannels = 1;
                this.NumCols = bufferedImage.getWidth();
                this.NumRows = bufferedImage.getHeight();
                this.chanData = new Object[this.NumChannels];
                this.DataOffsets = new int[this.NumChannels];
                this.OffsetColumn = 4;
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
                this.OffsetRow = integerComponentRaster.getScanlineStride() * 4;
                int n = 0;
                while (n < this.NumChannels) {
                    this.chanData[n] = integerComponentRaster.getDataStorage();
                    this.DataOffsets[n] = integerComponentRaster.getDataOffset(n);
                    ++n;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.NumChannels = 1;
                this.NumCols = bufferedImage.getWidth();
                this.NumRows = bufferedImage.getHeight();
                this.chanData = new Object[this.NumChannels];
                this.DataOffsets = new int[this.NumChannels];
                this.OffsetColumn = this.Type == 5 ? 3 : 4;
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.OffsetRow = byteComponentRaster.getScanlineStride();
                int n = 0;
                while (n < this.NumChannels) {
                    this.chanData[n] = byteComponentRaster.getDataStorage();
                    this.DataOffsets[n] = byteComponentRaster.getDataOffset(n);
                    ++n;
                }
                break;
            }
            case 0: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            default: {
                System.out.println("Unknown type:" + this.Type);
            }
        }
    }
}

