/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import sun.misc.Launcher;

public final class Security {
    private static boolean reloadProviders = false;
    static final boolean debug = false;
    static final boolean error = true;
    private static Properties props;
    private static Vector providers;
    private static Hashtable providerPropertiesCache;
    private static Hashtable engineCache;
    private static Hashtable searchResultsCache;
    static /* synthetic */ Class class$java$security$Security;

    private static void initialize() {
        props = new Properties();
        providers = new Vector();
        providerPropertiesCache = new Hashtable();
        engineCache = new Hashtable();
        searchResultsCache = new Hashtable(5);
        File file = Security.securityPropFile("java.security");
        if (!file.exists()) {
            System.err.println("security properties not found. using defaults.");
            Security.initializeStatic();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                props.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                Security.error("could not load security properties file from " + file + ". using defaults.");
                Security.initializeStatic();
            }
        }
        Security.loadProviders();
    }

    private static void initializeStatic() {
        props.put("security.provider.1", "sun.security.provider.Sun");
    }

    private Security() {
    }

    private static synchronized void loadProviders() {
        String string;
        int n = 1;
        Launcher launcher = Launcher.getLauncher();
        while ((string = props.getProperty("security.provider." + n++)) != null) {
            Provider provider = Provider.loadProvider(string.trim());
            if (provider != null) {
                providers.addElement(provider);
                continue;
            }
            if (launcher != null) continue;
            reloadProviders = true;
        }
    }

    private static synchronized void reloadProviders() {
        Launcher launcher;
        if (reloadProviders && (launcher = Launcher.getLauncher()) != null) {
            String string;
            reloadProviders = false;
            providers.removeAllElements();
            int n = 1;
            while ((string = props.getProperty("security.provider." + n++)) != null) {
                Provider provider = (Provider)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Provider.loadProvider(string.trim());
                    }
                });
                if (provider == null) continue;
                providers.addElement(provider);
            }
            providerPropertiesCache.clear();
            engineCache.clear();
            searchResultsCache.clear();
        }
    }

    private static File securityPropFile(String string) {
        String string2 = File.separator;
        return new File(System.getProperty("java.home") + string2 + "lib" + string2 + "security" + string2 + string);
    }

    private static ProviderProperty getProviderProperty(String string) {
        ProviderProperty providerProperty = (ProviderProperty)providerPropertiesCache.get(string);
        if (providerProperty != null) {
            return providerProperty;
        }
        int n = 0;
        while (n < providers.size()) {
            Object object;
            String string2 = null;
            Provider provider = (Provider)providers.elementAt(n);
            String string3 = provider.getProperty(string);
            if (string3 == null) {
                object = provider.keys();
                while (object.hasMoreElements() && string3 == null) {
                    string2 = (String)object.nextElement();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    string3 = provider.getProperty(string2);
                    break;
                }
            }
            if (string3 != null) {
                object = new ProviderProperty();
                ((ProviderProperty)object).className = string3;
                ((ProviderProperty)object).provider = provider;
                providerPropertiesCache.put(string, object);
                if (string2 != null) {
                    providerPropertiesCache.put(string2, object);
                }
                return object;
            }
            ++n;
        }
        return providerProperty;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration enumeration = provider.keys();
            while (enumeration.hasMoreElements() && string2 == null) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = provider.getProperty(string3);
                break;
            }
        }
        return string2;
    }

    private static String getStandardName(String string, String string2, Provider provider) {
        return Security.getProviderProperty("Alg.Alias." + string2 + "." + string, provider);
    }

    public static String getAlgorithmProperty(String string, String string2) {
        Security.reloadProviders();
        ProviderProperty providerProperty = Security.getProviderProperty("Alg." + string2 + "." + string);
        if (providerProperty != null) {
            return providerProperty.className;
        }
        return null;
    }

    private static ProviderProperty getEngineClassName(String string, String string2) throws NoSuchAlgorithmException {
        ProviderProperty providerProperty;
        String string3 = string2;
        if (string != null) {
            string3 = string3 + "." + string;
        }
        if ((providerProperty = (ProviderProperty)engineCache.get(string3)) != null) {
            return providerProperty;
        }
        Class clazz = class$java$security$Security == null ? (class$java$security$Security = Security.class$("java.security.Security")) : class$java$security$Security;
        synchronized (clazz) {
            int n = 0;
            while (n < providers.size()) {
                block9: {
                    Provider provider = (Provider)providers.elementAt(n);
                    try {
                        providerProperty = Security.getEngineClassName(string, provider.getName(), string2);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        break block9;
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        break block9;
                    }
                    engineCache.put(string3, providerProperty);
                    ProviderProperty providerProperty2 = providerProperty;
                    return providerProperty2;
                }
                ++n;
            }
        }
        throw new NoSuchAlgorithmException(string.toUpperCase() + " " + string2 + " not available");
    }

    private static ProviderProperty getEngineClassName(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object object;
        if (string2 == null) {
            return Security.getEngineClassName(string, string3);
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + string2);
        }
        String string4 = string3.equalsIgnoreCase("SecureRandom") && string == null ? string3 : string3 + "." + string;
        String string5 = Security.getProviderProperty(string4, provider);
        if (string5 == null) {
            if (string3.equalsIgnoreCase("SecureRandom") && string == null) {
                throw new NoSuchAlgorithmException("SecureRandom not available for provider " + string2);
            }
            object = Security.getStandardName(string, string3, provider);
            if (object != null) {
                string4 = string3 + "." + (String)object;
            }
            if (object == null || (string5 = Security.getProviderProperty(string4, provider)) == null) {
                throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + string2);
            }
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).className = string5;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    public static synchronized int insertProviderAt(Provider provider, int n) {
        Security.reloadProviders();
        Security.check("insertProvider." + provider.getName());
        Provider provider2 = Security.getProvider(provider.getName());
        if (provider2 != null) {
            return -1;
        }
        int n2 = providers.size();
        if (n > n2 || n <= 0) {
            n = n2 + 1;
        }
        providers.insertElementAt(provider, n - 1);
        providerPropertiesCache.clear();
        engineCache.clear();
        searchResultsCache.clear();
        return n;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static synchronized void removeProvider(String string) {
        Security.reloadProviders();
        Security.check("removeProvider." + string);
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            Iterator iterator = providers.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != provider) continue;
                iterator.remove();
            }
            providerPropertiesCache.clear();
            engineCache.clear();
            searchResultsCache.clear();
        }
    }

    public static synchronized Provider[] getProviders() {
        Security.reloadProviders();
        Object[] objectArray = new Provider[providers.size()];
        providers.copyInto(objectArray);
        return objectArray;
    }

    public static synchronized Provider getProvider(String string) {
        Security.reloadProviders();
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.getName().equals(string)) continue;
            return provider;
        }
        return null;
    }

    public static Provider[] getProviders(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n == -1) {
            string2 = new String(string);
            string3 = "";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Hashtable hashtable = new Hashtable(1);
        hashtable.put(string2, string3);
        return Security.getProviders(hashtable);
    }

    public static Provider[] getProviders(Map map) {
        Provider[] providerArray;
        Object[] objectArray;
        Provider[] providerArray2 = Security.getProviders();
        Set set = map.keySet();
        HashSet hashSet = new HashSet(5);
        if (set == null || providerArray2 == null) {
            return providerArray2;
        }
        boolean bl = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            providerArray = (Provider[])map.get(objectArray);
            HashSet hashSet2 = Security.getAllQualifyingCandidates((String)objectArray, (String)providerArray, providerArray2);
            if (bl) {
                hashSet = hashSet2;
                bl = false;
            }
            if (hashSet2 != null && !hashSet2.isEmpty()) {
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    Provider provider = (Provider)iterator2.next();
                    if (hashSet2.contains(provider)) continue;
                    iterator2.remove();
                }
                continue;
            }
            hashSet = null;
            break;
        }
        if (hashSet == null || hashSet.isEmpty()) {
            return null;
        }
        objectArray = hashSet.toArray();
        providerArray = new Provider[objectArray.length];
        int n = 0;
        while (n < providerArray.length) {
            providerArray[n] = (Provider)objectArray[n];
            ++n;
        }
        return providerArray;
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.reloadProviders();
        ProviderProperty providerProperty = Security.getEngineClassName(string, string3, string2);
        String string4 = providerProperty.className;
        try {
            Class clazz = string2.equals("CertificateFactory") ? Class.forName("java.security.cert." + string2 + "Spi") : Class.forName("java.security." + string2 + "Spi");
            ClassLoader classLoader = providerProperty.provider.getClass().getClassLoader();
            Class clazz2 = classLoader != null ? classLoader.loadClass(string4) : Class.forName(string4);
            if (Security.checkSuperclass(clazz2, clazz)) {
                Object object = clazz2.newInstance();
                return new Object[]{object, providerProperty.provider};
            }
            throw new NoSuchAlgorithmException("class configured for " + string2 + ": " + string4 + " not a " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("class configured for " + string2 + "(provider: " + string3 + ")" + "cannot be found.\n" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be instantiated.\n" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be accessed.\n" + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be accessed.\n" + securityException.getMessage());
        }
    }

    public static String getProperty(String string) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getProperty." + string));
        }
        if ((string2 = props.getProperty(string)) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        Security.check("setProperty." + string);
        props.put(string, string2);
        Security.invalidateSMCache(string);
    }

    private static void invalidateSMCache(String string) {
        final boolean bl = string.equals("package.access");
        boolean bl2 = string.equals("package.definition");
        if (bl || bl2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class clazz = Class.forName("java.lang.SecurityManager", false, null);
                        Field field = null;
                        boolean bl2 = false;
                        if (bl) {
                            field = clazz.getDeclaredField("packageAccessValid");
                            bl2 = field.isAccessible();
                            field.setAccessible(true);
                        } else {
                            field = clazz.getDeclaredField("packageDefinitionValid");
                            bl2 = field.isAccessible();
                            field.setAccessible(true);
                        }
                        field.setBoolean(field, false);
                        field.setAccessible(bl2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    static void error(String string) {
    }

    static void error(String string, Throwable throwable) {
        Security.error(string);
    }

    static void debug(String string) {
    }

    static void debug(String string, Throwable throwable) {
    }

    private static HashSet getAllQualifyingCandidates(String string, String string2, Provider[] providerArray) {
        String[] stringArray = Security.getFilterComponents(string, string2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = string3 + '.' + string4;
        HashSet hashSet = (HashSet)searchResultsCache.get(string6);
        HashSet hashSet2 = Security.getProvidersNotUsingCache(string3, string4, null, null, null, providerArray);
        if (hashSet2 == null || hashSet2.isEmpty()) {
            return null;
        }
        searchResultsCache.put(string6, hashSet2);
        if (string5 == null) {
            return hashSet2;
        }
        return Security.getProvidersNotUsingCache(string3, string4, string5, string2, hashSet, providerArray);
    }

    private static HashSet getProvidersNotUsingCache(String string, String string2, String string3, String string4, HashSet hashSet, Provider[] providerArray) {
        if (string3 != null && hashSet != null && !hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Provider provider = (Provider)iterator.next();
                if (Security.isCriterionSatisfied(provider, string, string2, string3, string4)) continue;
                iterator.remove();
            }
        }
        if (hashSet == null || hashSet.isEmpty()) {
            if (hashSet == null) {
                hashSet = new HashSet(5);
            }
            int n = 0;
            while (n < providerArray.length) {
                if (Security.isCriterionSatisfied(providerArray[n], string, string2, string3, string4)) {
                    hashSet.add(providerArray[n]);
                }
                ++n;
            }
        }
        return hashSet;
    }

    private static boolean isCriterionSatisfied(Provider provider, String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string + '.' + string2;
        if (string3 != null) {
            string6 = string6 + ' ' + string3;
        }
        if ((string5 = Security.getProviderProperty(string6, provider)) == null) {
            String string7 = Security.getProviderProperty("Alg.Alias." + string + "." + string2, provider);
            if (string7 != null) {
                string6 = string + "." + string7;
                if (string3 != null) {
                    string6 = string6 + ' ' + string3;
                }
                string5 = Security.getProviderProperty(string6, provider);
            }
            if (string5 == null) {
                return false;
            }
        }
        if (string3 == null) {
            return true;
        }
        if (Security.isStandardAttr(string3)) {
            return Security.isConstraintSatisfied(string3, string4, string5);
        }
        return string4.equalsIgnoreCase(string5);
    }

    private static boolean isStandardAttr(String string) {
        if (string.equalsIgnoreCase("KeySize")) {
            return true;
        }
        return string.equalsIgnoreCase("ImplementedIn");
    }

    private static boolean isConstraintSatisfied(String string, String string2, String string3) {
        if (string.equalsIgnoreCase("KeySize")) {
            int n;
            int n2 = new Integer(string2);
            return n2 <= (n = new Integer(string3).intValue());
        }
        if (string.equalsIgnoreCase("ImplementedIn")) {
            return string2.equalsIgnoreCase(string3);
        }
        return false;
    }

    static String[] getFilterComponents(String string, String string2) {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new InvalidParameterException("Invalid filter");
        }
        String string3 = string.substring(0, n);
        String string4 = null;
        String string5 = null;
        if (string2.length() == 0) {
            string4 = string.substring(n + 1).trim();
            if (string4.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
        } else {
            int n2 = string.indexOf(32);
            if (n2 == -1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string5 = string.substring(n2 + 1).trim();
            if (string5.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
            if (n2 < n || n == n2 - 1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string4 = string.substring(n + 1, n2);
        }
        String[] stringArray = new String[]{string3, string4, string5};
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.initialize();
                return null;
            }
        });
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

