/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.core.EndPoint;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.EndPointImpl;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.util.Utility;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class ConnectionTable {
    protected ORB orb;
    protected Hashtable connectionCache = new Hashtable();
    protected long globalCounter = 0L;
    private int MAX_SOCKET_RETRIES = 5;
    protected ServerGIOP server;
    private static final int LOW_WATER_MARK = 100;
    private static final int HIGH_WATER_MARK = 240;
    private static final int NCLEAN = 5;

    public ConnectionTable(ORB oRB, ServerGIOP serverGIOP) {
        this.orb = oRB;
        this.server = serverGIOP;
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public Connection get(EndPoint endPoint) {
        Connection connection;
        if (this.orb.transportDebugFlag) {
            this.dprint("Client get called: host = " + endPoint.getHostName() + " port = " + endPoint.getPort());
        }
        if ((connection = (Connection)this.connectionCache.get(endPoint)) != null) {
            if (this.orb.transportDebugFlag) {
                this.dprint("Returning connection " + connection + " from table");
            }
            return connection;
        }
        ConnectionTable connectionTable = this;
        synchronized (connectionTable) {
            connection = (Connection)this.connectionCache.get(endPoint);
            if (connection != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Returning connection " + connection + " from table");
                }
                Connection connection2 = connection;
                return connection2;
            }
            connection = new IIOPConnection(this.orb, this.server, this, endPoint);
            this.stampTime(connection);
            this.connectionCache.put(endPoint, connection);
            if (this.orb.transportDebugFlag) {
                this.dprint("Creating new connection " + connection);
            }
        }
        int n = 0;
        while (true) {
            try {
                Socket socket = Connection.newSocket(this.orb, endPoint);
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connection.setConnection(socket, this);
                this.checkConnectionTable();
            }
            catch (SocketException socketException) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("SocketException " + socketException + " while creating socket for new connection");
                }
                if (socketException instanceof BindException || socketException instanceof ConnectException || socketException instanceof NoRouteToHostException) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Serious error: aborting connection");
                    }
                    connection.abortConnection();
                    throw new COMM_FAILURE(1398079489, CompletionStatus.COMPLETED_NO);
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint("Attempting resource cleanup and retry on socket creation");
                }
                if (n == this.MAX_SOCKET_RETRIES || !this.cleanUp()) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Out of resources: aborting connection");
                    }
                    connection.abortConnection();
                    throw new COMM_FAILURE(1398079489, CompletionStatus.COMPLETED_NO);
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Exception " + exception + " while creating socket for new connection: aborting connection");
                }
                connection.abortConnection();
                throw new COMM_FAILURE(1398079489, CompletionStatus.COMPLETED_NO);
            }
            break;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint("Succesfully created socket for new connection");
        }
        return connection;
    }

    public synchronized Connection get(Socket socket) {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint("Server get: sockect " + socket);
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = socket.getInputStream();
                outputStream = socket.getOutputStream();
            }
            catch (Exception exception) {
                throw new COMM_FAILURE(1398079489, CompletionStatus.COMPLETED_NO);
            }
            String string = socket.getInetAddress().getHostName();
            int n = socket.getPort();
            EndPointImpl endPointImpl = new EndPointImpl(123, n, string);
            if (this.orb.transportDebugFlag) {
                this.dprint("host = " + string + " port = " + n);
            }
            IIOPConnection iIOPConnection = new IIOPConnection(this.orb, this.server, endPointImpl, socket, inputStream, outputStream, this);
            this.connectionCache.put(endPointImpl, iIOPConnection);
            this.stampTime(iIOPConnection);
            if (this.orb.transportDebugFlag) {
                this.dprint("Created connection " + iIOPConnection);
            }
            return iIOPConnection;
        }
        catch (Exception exception) {
            if (this.orb.transportDebugFlag) {
                this.dprint("Exception " + exception + " on creating connection");
            }
            try {
                socket.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    public synchronized void deleteConn(EndPoint endPoint) {
        if (this.orb.transportDebugFlag) {
            this.dprint("DeleteConn called: host = " + endPoint.getHostName() + " port = " + endPoint.getPort());
        }
        this.connectionCache.remove(endPoint);
    }

    public boolean cleanUp() {
        if (this.orb.transportDebugFlag) {
            this.dprint("Cleanup called");
        }
        if (this.connectionCache.size() < 100) {
            if (this.orb.transportDebugFlag) {
                this.dprint("Cleanup returns false: not enough connections open to start cleanup");
            }
            return false;
        }
        int n = 0;
        while (n < 5) {
            Connection connection = null;
            long l = Long.MAX_VALUE;
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection2 = (Connection)enumeration.nextElement();
                if (connection2.isBusy() || connection2.timeStamp >= l) continue;
                connection = connection2;
                l = connection2.timeStamp;
            }
            if (connection == null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Cleanup returns false: all connections busy");
                }
                return false;
            }
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Cleanup is cleaning connection " + connection);
                }
                connection.cleanUp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return true;
    }

    public void checkConnectionTable() {
        if (this.connectionCache.size() > 240) {
            this.cleanUp();
        }
    }

    public synchronized void stampTime(Connection connection) {
        connection.timeStamp = this.globalCounter++;
    }

    void destroyConnections() {
        Enumeration enumeration = this.connectionCache.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.shutdown();
        }
    }

    public synchronized void print() {
        System.out.println("***ConnectionTable***");
        int n = this.connectionCache.size();
        System.out.println("  SIZE=" + n);
        if (n < 10) {
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.print();
            }
        }
    }
}

