/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

public class BasicTextAreaUI
extends BasicTextUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTextAreaUI();
    }

    protected String getPropertyPrefix() {
        return "TextArea";
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Document document;
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("lineWrap") || propertyChangeEvent.getPropertyName().equals("wrapStyleWord")) {
            this.modelChanged();
        }
        if ("font".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(object = (document = this.editor.getDocument()).getProperty("i18n"))) {
            this.modelChanged();
        }
    }

    public View create(Element element) {
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE)) {
            return this.createI18N(element);
        }
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)jTextComponent;
            View view = jTextArea.getLineWrap() ? new WrappedPlainView(element, jTextArea.getWrapStyleWord()) : new PlainView(element);
            return view;
        }
        return null;
    }

    View createI18N(Element element) {
        String string = element.getName();
        if (string != null) {
            if (string.equals("content")) {
                return new PlainParagraph(element);
            }
            if (string.equals("paragraph")) {
                return new BoxView(element, 1);
            }
        }
        return null;
    }

    static class PlainParagraph
    extends ParagraphView {
        PlainParagraph(Element element) {
            super(element);
            this.layoutPool = new LogicalView(element);
            this.layoutPool.setParent(this);
        }

        public void setParent(View view) {
            super.setParent(view);
            this.setPropertiesFromAttributes();
        }

        protected void setPropertiesFromAttributes() {
            Container container = this.getContainer();
            if (container != null && !container.getComponentOrientation().isLeftToRight()) {
                this.setJustification(2);
            } else {
                this.setJustification(0);
            }
        }

        public int getFlowSpan(int n) {
            JTextArea jTextArea;
            Container container = this.getContainer();
            if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                return Integer.MAX_VALUE;
            }
            return super.getFlowSpan(n);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
            Container container = this.getContainer();
            if (container instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)container;
                if (!jTextArea.getLineWrap()) {
                    sizeRequirements2.minimum = sizeRequirements2.preferred;
                } else {
                    sizeRequirements2.minimum = 0;
                    sizeRequirements2.preferred = this.getWidth();
                }
            }
            return sizeRequirements2;
        }

        public void setSize(float f, float f2) {
            if ((int)f != this.getWidth()) {
                this.preferenceChanged(null, true, true);
            }
            super.setSize(f, f2);
        }

        static class LogicalView
        extends CompositeView {
            LogicalView(Element element) {
                super(element);
            }

            protected int getViewIndexAtPosition(int n) {
                Element element = this.getElement();
                if (element.getElementCount() > 0) {
                    return element.getElementIndex(n);
                }
                return 0;
            }

            protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
                return false;
            }

            protected void loadChildren(ViewFactory viewFactory) {
                Element element = this.getElement();
                if (element.getElementCount() > 0) {
                    super.loadChildren(viewFactory);
                } else {
                    GlyphView glyphView = new GlyphView(element);
                    this.append(glyphView);
                }
            }

            public float getPreferredSpan(int n) {
                if (this.getViewCount() != 1) {
                    throw new Error("One child view is assumed.");
                }
                View view = this.getView(0);
                return view.getPreferredSpan(n);
            }

            protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
                view.setParent(this);
                super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
            }

            public void paint(Graphics graphics, Shape shape) {
            }

            protected boolean isBefore(int n, int n2, Rectangle rectangle) {
                return false;
            }

            protected boolean isAfter(int n, int n2, Rectangle rectangle) {
                return false;
            }

            protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
                return null;
            }

            protected void childAllocation(int n, Rectangle rectangle) {
            }
        }
    }
}

