/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;

public class BytePackedRaster
extends WritableRaster {
    int dataBitOffset;
    int scanlineStride;
    int pixelBitStride;
    int numberOfBits;
    int bitMask;
    byte[] data;
    int shiftOffset;
    int type;

    private static native void initIDs();

    public BytePackedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, BytePackedRaster bytePackedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, bytePackedRaster);
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("BytePackedRasters must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (dataBufferByte.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for BytePackedRasters must only have 1 bank.");
        }
        int n = dataBufferByte.getOffset();
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            this.type = 11;
            this.scanlineStride = multiPixelPackedSampleModel.getScanlineStride();
            this.pixelBitStride = multiPixelPackedSampleModel.getPixelBitStride();
            this.numberOfBits = multiPixelPackedSampleModel.getPixelBitStride();
            this.dataBitOffset = multiPixelPackedSampleModel.getDataBitOffset() + n * 8;
            int n2 = rectangle.x - point.x;
            int n3 = rectangle.y - point.y;
            this.dataBitOffset += n2 * this.pixelBitStride + n3 * this.scanlineStride * 8;
        } else {
            throw new RasterFormatException("BytePackedRasters must haveMultiPixelPackedSampleModel");
        }
        this.bitMask = (1 << this.numberOfBits) - 1;
        this.shiftOffset = 8 - this.pixelBitStride;
        this.verify(false);
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n, int n2, Object object) {
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = this.dataBitOffset + (n - this.minX) * this.pixelBitStride;
        int n4 = this.data[(n2 - this.minY) * this.scanlineStride + (n3 >> 3)] & 0xFF;
        int n5 = this.shiftOffset - (n3 & 7);
        byArray[0] = (byte)(n4 >> n5 & this.bitMask);
        return byArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.getByteData(n, n2, n3, n4, (byte[])object);
    }

    public Object getPixelData(int n, int n2, int n3, int n4, Object object) {
        byte[] byArray = object == null ? new byte[this.numDataElements * n3 * n4] : (byte[])object;
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n6;
            int n11 = 0;
            while (n11 < n3) {
                int n12 = this.shiftOffset - (n10 & 7);
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + (n10 >> 3)] >> n12);
                n10 += n5;
                ++n11;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        return this.getByteData(n, n2, n3, n4, byArray);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[n3 * n4];
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11 = n6;
            int n12 = 0;
            while (n12 < n3 && (n11 & 7) != 0) {
                n10 = this.shiftOffset - (n11 & 7);
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + (n11 >> 3)] >> n10);
                n11 += n5;
                ++n12;
            }
            n10 = n7 + (n11 >> 3);
            switch (n5) {
                case 1: {
                    byte by;
                    while (n12 < n3 - 7) {
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 7 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 6 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 5 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 3 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 2 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 1 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        n11 += 8;
                        n12 += 8;
                    }
                    break;
                }
                case 2: {
                    byte by;
                    while (n12 < n3 - 7) {
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 6 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 2 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 6 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by >> 2 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        n11 += 16;
                        n12 += 8;
                    }
                    break;
                }
                case 4: {
                    byte by;
                    while (n12 < n3 - 7) {
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        by = byArray2[n10++];
                        byArray[n8++] = (byte)(by >> 4 & this.bitMask);
                        byArray[n8++] = (byte)(by & this.bitMask);
                        n11 += 32;
                        n12 += 8;
                    }
                    break;
                }
                case 8: {
                    while (n12 < n3 - 7) {
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        byArray[n8++] = byArray2[n10++];
                        n11 += 64;
                        n12 += 8;
                    }
                    break;
                }
            }
            while (n12 < n3) {
                int n13 = this.shiftOffset - (n11 & 7);
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + (n11 >> 3)] >> n13);
                n11 += n5;
                ++n12;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
        return byArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        byte[] byArray = (byte[])object;
        if (n < this.minX) {
            throw new ArrayIndexOutOfBoundsException("X (" + n + ") is less than " + "minX (" + this.minX + ").");
        }
        if (n2 < this.minY) {
            throw new ArrayIndexOutOfBoundsException("Y (" + n2 + ") is less than " + "minY (" + this.minY + ").");
        }
        int n3 = this.dataBitOffset + (n - this.minX) * this.pixelBitStride;
        int n4 = (n2 - this.minY) * this.scanlineStride + (n3 >> 3);
        int n5 = this.shiftOffset - (n3 & 7);
        byte by = this.data[n4];
        by = (byte)(by & ~(this.bitMask << n5));
        this.data[n4] = by = (byte)(by | (byArray[0] & this.bitMask) << n5);
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (this.pixelBitStride == this.numberOfBits && raster instanceof BytePackedRaster) {
            int n5;
            int n6;
            int n7;
            BytePackedRaster bytePackedRaster = (BytePackedRaster)raster;
            if (bytePackedRaster.pixelBitStride == this.pixelBitStride && bytePackedRaster.numberOfBits == this.numberOfBits && ((n7 = bytePackedRaster.dataBitOffset) & 7) == ((n6 = this.dataBitOffset + 8 * (n2 - this.minY) * (n5 = this.scanlineStride) + (n - this.minX) * this.pixelBitStride) & 7)) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                byte[] byArray = bytePackedRaster.data;
                byte[] byArray2 = this.data;
                int n13 = bytePackedRaster.scanlineStride;
                int n14 = n3 * this.numberOfBits;
                int n15 = n7 & 7;
                if (n15 != 0) {
                    n12 = n7 >> 3;
                    n11 = n6 >> 3;
                    n10 = 255 >> n15;
                    if (n14 < (n15 = 8 - n15)) {
                        n10 &= n10 << 8 - n14;
                        n15 = n14;
                    }
                    n9 = 0;
                    while (n9 < n4) {
                        n8 = byArray2[n11];
                        n8 &= ~n10;
                        byArray2[n11] = (byte)(n8 |= byArray[n12] & n10);
                        n12 += n13;
                        n11 += n5;
                        ++n9;
                    }
                    n7 += n15;
                    n6 += n15;
                    n14 -= n15;
                }
                if (n14 >= 8) {
                    n12 = n7 >> 3;
                    n11 = n6 >> 3;
                    n10 = n14 >> 3;
                    if (n10 == n13 && n13 == n5) {
                        System.arraycopy(byArray, n12, byArray2, n11, n13 * bytePackedRaster.height);
                    } else {
                        n9 = 0;
                        while (n9 < n4) {
                            System.arraycopy(byArray, n12, byArray2, n11, n10);
                            n12 += n13;
                            n11 += n5;
                            ++n9;
                        }
                    }
                    n15 = n10 * 8;
                    n7 += n15;
                    n6 += n15;
                    n14 -= n15;
                }
                if (n14 > 0) {
                    n12 = n7 >> 3;
                    n11 = n6 >> 3;
                    n10 = 65280 >> n14 & 0xFF;
                    n9 = 0;
                    while (n9 < n4) {
                        n8 = byArray2[n11];
                        n8 &= ~n10;
                        byArray2[n11] = (byte)(n8 |= byArray[n12] & n10);
                        n12 += n13;
                        n11 += n5;
                        ++n9;
                    }
                }
                return;
            }
        }
        super.setDataElements(n, n2, raster);
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.putByteData(n, n2, n3, n4, (byte[])object);
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.putByteData(n, n2, n3, n4, byArray);
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX) {
            throw new ArrayIndexOutOfBoundsException("X (" + n + ") is less than " + "minX (" + this.minX + ").");
        }
        if (n2 < this.minY) {
            throw new ArrayIndexOutOfBoundsException("Y (" + n2 + ") is less than " + "minY (" + this.minY + ").");
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.minX) * n5;
        int n7 = (n2 - this.minY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12 = n6;
            int n13 = 0;
            while (n13 < n3 && (n12 & 7) != 0) {
                n11 = this.shiftOffset - (n12 & 7);
                n10 = byArray2[n7 + (n12 >> 3)];
                n10 &= ~(this.bitMask << n11);
                byArray2[n7 + (n12 >> 3)] = (byte)(n10 |= (byArray[n8++] & this.bitMask) << n11);
                n12 += n5;
                ++n13;
            }
            n11 = n7 + (n12 >> 3);
            switch (n5) {
                case 1: {
                    while (n13 < n3 - 7) {
                        n10 = (byArray[n8++] & this.bitMask) << 7;
                        n10 |= (byArray[n8++] & this.bitMask) << 6;
                        n10 |= (byArray[n8++] & this.bitMask) << 5;
                        n10 |= (byArray[n8++] & this.bitMask) << 4;
                        n10 |= (byArray[n8++] & this.bitMask) << 3;
                        n10 |= (byArray[n8++] & this.bitMask) << 2;
                        n10 |= (byArray[n8++] & this.bitMask) << 1;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n12 += 8;
                        n13 += 8;
                    }
                    break;
                }
                case 2: {
                    while (n13 < n3 - 7) {
                        n10 = (byArray[n8++] & this.bitMask) << 6;
                        n10 |= (byArray[n8++] & this.bitMask) << 4;
                        n10 |= (byArray[n8++] & this.bitMask) << 2;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n10 = (byArray[n8++] & this.bitMask) << 6;
                        n10 |= (byArray[n8++] & this.bitMask) << 4;
                        n10 |= (byArray[n8++] & this.bitMask) << 2;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n12 += 16;
                        n13 += 8;
                    }
                    break;
                }
                case 4: {
                    while (n13 < n3 - 7) {
                        n10 = (byArray[n8++] & this.bitMask) << 4;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n10 = (byArray[n8++] & this.bitMask) << 4;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n10 = (byArray[n8++] & this.bitMask) << 4;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n10 = (byArray[n8++] & this.bitMask) << 4;
                        byArray2[n11++] = (byte)(n10 |= byArray[n8++] & this.bitMask);
                        n12 += 32;
                        n13 += 8;
                    }
                    break;
                }
                case 8: {
                    while (n13 < n3 - 7) {
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        byArray2[n11++] = byArray[n8++];
                        n12 += 64;
                        n13 += 8;
                    }
                    break;
                }
            }
            while (n13 < n3) {
                int n14 = this.shiftOffset - (n12 & 7);
                n10 = byArray2[n7 + (n12 >> 3)];
                n10 &= ~(this.bitMask << n14);
                byArray2[n7 + (n12 >> 3)] = (byte)(n10 |= (byArray[n8++] & this.bitMask) << n14);
                n12 += n5;
                ++n13;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new BytePackedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new BytePackedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        if (this.dataBitOffset < 0) {
            throw new RasterFormatException("Data offsets must be >= 0");
        }
        int n = this.dataBitOffset + (this.height - 1) * this.scanlineStride * 8 + (this.width - 1) * this.pixelBitStride + this.numberOfBits - 1;
        if (n / 8 >= this.data.length) {
            throw new RasterFormatException("raster dimensions overflow array bounds");
        }
        if (bl && this.height > 1 && (n = (this.width - 1) * this.pixelBitStride + this.numberOfBits - 1) / 8 >= this.scanlineStride) {
            throw new RasterFormatException("data for adjacent scanlines overlaps");
        }
    }

    public String toString() {
        return new String("BytePackedRaster: width = " + this.width + " height = " + this.height + " #channels " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY);
    }

    static {
        NativeLibLoader.loadLibraries();
        BytePackedRaster.initIDs();
    }
}

