/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.tools.Executable;
import com.lowagie.tools.ToolMenuItems;
import com.lowagie.tools.arguments.ToolArgument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractTool
implements ToolMenuItems,
ActionListener {
    public static ArrayList versionsarray = new ArrayList();
    protected JInternalFrame internalFrame = null;
    protected ArrayList arguments = new ArrayList();
    protected int menuoptions = 1;
    public static final int MENU_EXECUTE = 1;
    public static final int MENU_EXECUTE_SHOW = 2;
    public static final int MENU_EXECUTE_PRINT = 4;
    public static final int MENU_EXECUTE_PRINT_SILENT = 8;

    public void setArguments(ArrayList arrayList) {
        this.arguments = arrayList;
    }

    public void setArguments(String[] stringArray) {
        int n = 0;
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ToolArgument toolArgument = (ToolArgument)iterator.next();
            if (stringArray.length <= n) break;
            toolArgument.setValue(stringArray[n]);
            ++n;
        }
    }

    public ArrayList getArguments() {
        return this.arguments;
    }

    public Object getValue(String string) throws InstantiationException {
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ToolArgument toolArgument = (ToolArgument)iterator.next();
            if (!string.equals(toolArgument.getName())) continue;
            return toolArgument.getArgument();
        }
        return null;
    }

    public void setInternalFrame(JInternalFrame jInternalFrame) {
        this.internalFrame = jInternalFrame;
    }

    public JInternalFrame getInternalFrame() {
        if (this.internalFrame == null) {
            this.createFrame();
        }
        return this.internalFrame;
    }

    public JMenuBar getMenubar() {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Tool");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem2 = new JMenuItem("Usage");
        jMenuItem2.setMnemonic(85);
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Arguments");
        jMenuItem3.setMnemonic(65);
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        if ((this.menuoptions & 1) > 0) {
            jMenuItem = new JMenuItem("Execute");
            jMenuItem.setMnemonic(69);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if ((this.menuoptions & 2) > 0) {
            jMenuItem = new JMenuItem("Execute+Open");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if ((this.menuoptions & 4) > 0) {
            jMenuItem = new JMenuItem("Execute+Printdialog");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if ((this.menuoptions & 8) > 0) {
            jMenuItem = new JMenuItem("Execute+Print");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        if (this.arguments.size() > 0) {
            JMenu jMenu2 = new JMenu("Arguments");
            jMenu.setMnemonic(84);
            Iterator iterator = this.arguments.iterator();
            while (iterator.hasNext()) {
                ToolArgument toolArgument = (ToolArgument)iterator.next();
                JMenuItem jMenuItem4 = new JMenuItem(toolArgument.getName());
                jMenuItem4.setToolTipText(toolArgument.getDescription());
                jMenuItem4.addActionListener(toolArgument);
                jMenu2.add(jMenuItem4);
            }
            jMenuBar.add(jMenu2);
        }
        return jMenuBar;
    }

    public JScrollPane getConsole(int n, int n2) {
        try {
            Console console = new Console(n, n2);
            return new JScrollPane(console.textArea);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getUsage() {
        ToolArgument toolArgument;
        StringBuffer stringBuffer = new StringBuffer("java ");
        stringBuffer.append(this.getClass().getName());
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            toolArgument = (ToolArgument)iterator.next();
            stringBuffer.append(" ");
            stringBuffer.append(toolArgument.getName());
        }
        stringBuffer.append("\n");
        iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            toolArgument = (ToolArgument)iterator.next();
            stringBuffer.append(toolArgument.getUsage());
        }
        return stringBuffer.toString();
    }

    public String getArgs() {
        StringBuffer stringBuffer = new StringBuffer("Current arguments:\n");
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ToolArgument toolArgument = (ToolArgument)iterator.next();
            stringBuffer.append("  ");
            stringBuffer.append(toolArgument.getName());
            if (toolArgument.getValue() == null) {
                stringBuffer.append(" = null\n");
                continue;
            }
            stringBuffer.append(" = '");
            stringBuffer.append(toolArgument.getValue());
            stringBuffer.append("'\n");
        }
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Close".equals(actionEvent.getActionCommand())) {
            this.internalFrame.dispose();
        }
        if ("Usage".equals(actionEvent.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getUsage());
        }
        if ("Arguments".equals(actionEvent.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getArgs());
        }
        if ("Execute".equals(actionEvent.getActionCommand())) {
            this.execute();
        }
        if ("Execute+Open".equals(actionEvent.getActionCommand())) {
            this.execute();
            try {
                Executable.openDocument(this.getDestPathPDF());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        if ("Execute+Printdialog".equals(actionEvent.getActionCommand())) {
            this.execute();
            try {
                Executable.printDocument(this.getDestPathPDF());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        if ("Execute+Print".equals(actionEvent.getActionCommand())) {
            this.execute();
            try {
                Executable.printDocumentSilent(this.getDestPathPDF());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    protected abstract File getDestPathPDF() throws InstantiationException;

    protected abstract void createFrame();

    public abstract void execute();

    public abstract void valueHasChanged(ToolArgument var1);

    protected static void addVersion(String string) {
        string = string.substring(5, string.length() - 7);
        string = string.substring(0, string.lastIndexOf(" "));
        versionsarray.add(string);
    }

    public class Console {
        PipedInputStream piOut;
        PipedInputStream piErr;
        PipedOutputStream poOut;
        PipedOutputStream poErr;
        JTextArea textArea = new JTextArea();

        public Console(int n, int n2) throws IOException {
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            System.setOut(new PrintStream(this.poOut, true));
            this.piErr = new PipedInputStream();
            this.poErr = new PipedOutputStream(this.piErr);
            System.setErr(new PrintStream(this.poErr, true));
            this.textArea.setEditable(false);
            this.textArea.setRows(n2);
            this.textArea.setColumns(n);
            new ReaderThread(this.piOut).start();
            new ReaderThread(this.piErr).start();
        }

        class ReaderThread
        extends Thread {
            PipedInputStream pi;

            ReaderThread(PipedInputStream pipedInputStream) {
                this.pi = pipedInputStream;
            }

            public void run() {
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = this.pi.read(byArray)) != -1) {
                        Console.this.textArea.append(new String(byArray, 0, n));
                        Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

