/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    protected Stack filestack;
    protected Stack outline;
    protected Stack tagstack = new Stack();
    protected Stack objectstack = new Stack();
    protected Chunk currentChunk = null;
    protected Document document;
    protected PdfWriter writer;
    protected String title;
    protected String[] structures;
    protected String[] titles;
    protected int[] counterParents;
    protected int[] counters;
    protected int previoustitle = -1;
    protected MarkupParser markup;

    public Parser(String string) {
        this(string, "title", null, null, null);
    }

    public Parser(String string, String string2, String[] stringArray, String[] stringArray2, int[] nArray) {
        this.filestack = new Stack();
        this.filestack.push(string);
        this.title = string2;
        if (stringArray == null || stringArray2 == null || nArray == null) {
            this.counters = new int[0];
        } else {
            this.structures = stringArray;
            this.titles = stringArray2;
            this.counterParents = nArray;
            this.counters = new int[nArray.length];
        }
        this.document = new Document();
        try {
            this.parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (this.flushObject()) {
        }
        this.document.close();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Properties properties = new Properties();
        properties.put("tag", string3);
        for (int i = 0; i < attributes.getLength(); ++i) {
            properties.put(attributes.getQName(i), attributes.getValue(i));
        }
        this.tagstack.push(properties);
        if (this.document.isOpen()) {
            this.flushCurrentChunk();
            Element element = this.markup.getObject(properties);
            if (element != null) {
                switch (element.type()) {
                    case 11: {
                        this.addObject((Phrase)element);
                        break;
                    }
                    case 12: {
                        this.addObject((Paragraph)element);
                        break;
                    }
                    case 22: {
                        this.addObject((SimpleTable)element);
                        break;
                    }
                    case 20: {
                        this.addObject((SimpleCell)element);
                    }
                }
            }
        } else if ("body".equals(string3)) {
            Rectangle rectangle = this.markup.getRectangle(properties);
            if (rectangle != null) {
                this.document.setPageSize(rectangle);
            }
            this.document.open();
            if (this.writer != null) {
                this.outline = new Stack();
                PdfContentByte pdfContentByte = this.writer.getDirectContent();
                this.outline.push(pdfContentByte.getRootOutline());
            }
        } else if ("link".equals(string3) && "stylesheet".equals(properties.getProperty("rel"))) {
            String string4 = new File((String)this.filestack.peek()).getParent();
            String string5 = properties.getProperty("href");
            string5 = string5.startsWith("/") ? string4 + string5 : string4 + "/" + string5;
            this.markup = new MarkupParser(string5);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        block6: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (bl) continue block6;
                    stringBuffer.append(c);
                    continue block6;
                }
                case '\n': {
                    if (i <= 0) continue block6;
                    bl = true;
                    stringBuffer.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
        }
        this.addToCurrentChunk(stringBuffer.toString());
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Properties properties = (Properties)this.tagstack.peek();
        PdfOutline pdfOutline = null;
        this.flushCurrentChunk();
        if (properties != null && this.title.equals(properties.getProperty("id")) && this.outline != null) {
            PdfOutline pdfOutline2 = (PdfOutline)this.outline.peek();
            PdfDestination pdfDestination = new PdfDestination(2, this.writer.getVerticalPosition(false));
            Paragraph paragraph = (Paragraph)this.objectstack.peek();
            pdfOutline = new PdfOutline(pdfOutline2, pdfDestination, paragraph);
        }
        this.tagstack.pop();
        this.flushObject();
        if (this.markup.getPageBreakAfter(properties)) {
            while (this.flushObject()) {
            }
            try {
                this.document.newPage();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        if (pdfOutline != null) {
            this.outline.push(pdfOutline);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if ("parse".equals(string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (this.filestack.size() > 0) {
                        string3 = new File((String)this.filestack.peek()).getParent() + "/" + string3.trim();
                    }
                    this.filestack.push(string3);
                    this.parse();
                }
            }
            if (this.document.isOpen()) {
                return;
            }
            if ("pdfwriter".equals(string)) {
                this.writer = PdfWriter.getInstance(this.document, new FileOutputStream(string2));
            } else if ("htmlwriter".equals(string)) {
                HtmlWriter.getInstance(this.document, new FileOutputStream(string2));
            } else if ("rtfwriter".equals(string)) {
                RtfWriter.getInstance(this.document, new FileOutputStream(string2));
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void flushCurrentChunk() {
        TextElementArray textElementArray;
        if (this.currentChunk == null || !this.document.isOpen()) {
            return;
        }
        try {
            textElementArray = (TextElementArray)this.objectstack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            textElementArray = new Paragraph();
        }
        textElementArray.add(this.currentChunk);
        this.objectstack.push(textElementArray);
        this.currentChunk = null;
    }

    private void addToCurrentChunk(String string) {
        if (this.currentChunk != null) {
            this.currentChunk.append(string);
        } else {
            try {
                this.currentChunk = new Chunk(string, ((Phrase)this.objectstack.peek()).font());
            }
            catch (Exception exception) {
                this.currentChunk = new Chunk(string);
            }
        }
    }

    private void addObject(Phrase phrase) {
        this.objectstack.push(phrase);
    }

    private void addObject(SimpleTable simpleTable) {
        this.objectstack.push(simpleTable);
    }

    private void addObject(SimpleCell simpleCell) {
        this.objectstack.push(simpleCell);
    }

    private void addObject(Paragraph paragraph) {
        Properties properties = (Properties)this.tagstack.peek();
        if (properties == null) {
            return;
        }
        if (this.title.equals(properties.getProperty("id"))) {
            for (int i = 0; i < this.counters.length; ++i) {
                String string;
                if (!this.structures[i].equals(properties.getProperty("class"))) continue;
                int n = i;
                this.counters[n] = this.counters[n] + 1;
                while (this.previoustitle > -1 && this.counterParents[this.previoustitle] >= this.counterParents[i]) {
                    this.outline.pop();
                    this.previoustitle = this.counterParents[this.previoustitle];
                }
                this.previoustitle = i;
                for (int j = i + 1; j < this.counters.length; ++j) {
                    if (this.counterParents[j] != i || this.titles[j] != null) continue;
                    this.counters[j] = 0;
                    break;
                }
                if ((string = this.titles[i]) == null) {
                    string = "";
                    int n2 = this.counterParents[i];
                    while (n2 > 1) {
                        string = String.valueOf(this.counters[n2]) + "." + string;
                        n2 = this.counterParents[n2];
                    }
                    if (i > 0) {
                        string = string + String.valueOf(this.counters[i]) + " ";
                    }
                } else {
                    string = string + " " + this.counters[i] + ": ";
                }
                paragraph.add(new Chunk(string));
            }
        }
        if (this.markup.getPageBreakBefore(properties)) {
            while (this.flushObject()) {
            }
            try {
                this.document.newPage();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        this.objectstack.push(paragraph);
    }

    private boolean flushObject() {
        if (this.objectstack.size() == 0) {
            return false;
        }
        Element element = (Element)this.objectstack.pop();
        try {
            TextElementArray textElementArray = (TextElementArray)this.objectstack.peek();
            textElementArray.add(element);
            return true;
        }
        catch (EmptyStackException emptyStackException) {
            try {
                this.document.add(element);
                return true;
            }
            catch (DocumentException documentException) {
                return false;
            }
        }
    }

    private void parse() throws ParserConfigurationException, IOException, SAXException {
        String string = (String)this.filestack.peek();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.parse(new InputSource(string));
        this.filestack.pop();
    }
}

