/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class InspectPDF
extends AbstractTool {
    static /* synthetic */ Class class$java$lang$String;

    public InspectPDF() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The owner password if the file is encrypt", (class$java$lang$String == null ? (class$java$lang$String = InspectPDF.class$("java.lang.String")) : class$java$lang$String).getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Pdf Information", true, true, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(40, 30));
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            PdfReader pdfReader = this.getValue("ownerpassword") == null ? new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath()) : new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            System.out.println("=== Document Information ===");
            System.out.println("PDF Version: " + pdfReader.getPdfVersion());
            System.out.println("Number of pages: " + pdfReader.getNumberOfPages());
            System.out.println("Number of PDF objects: " + pdfReader.getXrefSize());
            System.out.println("File length: " + pdfReader.getFileLength());
            System.out.println("Encrypted? " + pdfReader.isEncrypted());
            if (pdfReader.isEncrypted()) {
                System.out.println("Permissions: " + PdfEncryptor.getPermissionsVerbose(pdfReader.getPermissions()));
                System.out.println("128 bit? " + pdfReader.is128Key());
            }
            System.out.println("Rebuilt? " + !pdfReader.isRebuilt());
            System.out.println("=== Metadata ===");
            HashMap hashMap = pdfReader.getInfo();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)hashMap.get(string);
                System.out.println(string + ": " + string2);
            }
            if (pdfReader.getMetadata() == null) {
                System.out.println("There is no XML Metadata in the file");
            } else {
                System.out.println("XML Metadata: " + new String(pdfReader.getMetadata()));
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        InspectPDF inspectPDF = new InspectPDF();
        if (stringArray.length < 1) {
            System.err.println(inspectPDF.getUsage());
        }
        inspectPDF.setArguments(stringArray);
        inspectPDF.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        InspectPDF.addVersion("$Id: InspectPDF.java,v 1.3 2005/08/29 09:21:56 blowagie Exp $");
    }
}

