/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.Subject;
import sun.security.ssl.Alert;
import sun.security.ssl.Authenticator;
import sun.security.ssl.ChangeCipherSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ClientHello;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLExtensions;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLSecretDerivation;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.StatusResponseManager;
import sun.security.ssl.SupportedVersionsExtension;
import sun.security.ssl.Utilities;

final class ServerHello {
    static final SSLConsumer handshakeConsumer = new ServerHelloConsumer();
    static final HandshakeProducer t12HandshakeProducer = new T12ServerHelloProducer();
    static final HandshakeProducer t13HandshakeProducer = new T13ServerHelloProducer();
    static final HandshakeProducer hrrHandshakeProducer = new T13HelloRetryRequestProducer();
    static final HandshakeProducer hrrReproducer = new T13HelloRetryRequestReproducer();
    private static final HandshakeConsumer t12HandshakeConsumer = new T12ServerHelloConsumer();
    private static final HandshakeConsumer t13HandshakeConsumer = new T13ServerHelloConsumer();
    private static final HandshakeConsumer t13HrrHandshakeConsumer = new T13HelloRetryRequestConsumer();

    ServerHello() {
    }

    private static void setUpPskKD(HandshakeContext handshakeContext, SecretKey secretKey) throws SSLHandshakeException {
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
            SSLLogger.fine("Using PSK to derive early secret", new Object[0]);
        }
        try {
            CipherSuite.HashAlg hashAlg = handshakeContext.negotiatedCipherSuite.hashAlg;
            HKDF hKDF = new HKDF(hashAlg.name);
            byte[] byArray = new byte[hashAlg.hashLength];
            SecretKey secretKey2 = hKDF.extract(byArray, secretKey, "TlsEarlySecret");
            handshakeContext.handshakeKeyDerivation = new SSLSecretDerivation(handshakeContext, secretKey2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
        }
    }

    private static final class T13HelloRetryRequestConsumer
    implements HandshakeConsumer {
        private T13HelloRetryRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            ServerHelloMessage serverHelloMessage = (ServerHelloMessage)handshakeMessage;
            if (serverHelloMessage.serverVersion != ProtocolVersion.TLS12) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "The HelloRetryRequest.legacy_version is not TLS 1.2");
            }
            clientHandshakeContext.negotiatedCipherSuite = serverHelloMessage.cipherSuite;
            SSLExtension[] sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.HELLO_RETRY_REQUEST);
            serverHelloMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            serverHelloMessage.extensions.consumeOnTrade(clientHandshakeContext, sSLExtensionArray);
            clientHandshakeContext.handshakeHash.finish();
            HandshakeOutStream handshakeOutStream = new HandshakeOutStream(null);
            try {
                clientHandshakeContext.initialClientHelloMsg.write(handshakeOutStream);
            }
            catch (IOException iOException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Failed to construct message hash", iOException);
            }
            clientHandshakeContext.handshakeHash.deliver(handshakeOutStream.toByteArray());
            clientHandshakeContext.handshakeHash.determine(clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.negotiatedCipherSuite);
            byte[] byArray = clientHandshakeContext.handshakeHash.digest();
            int n = clientHandshakeContext.negotiatedCipherSuite.hashAlg.hashLength;
            byte[] byArray2 = new byte[4 + n];
            byArray2[0] = SSLHandshake.MESSAGE_HASH.id;
            byArray2[1] = 0;
            byArray2[2] = 0;
            byArray2[3] = (byte)(n & 0xFF);
            System.arraycopy(byArray, 0, byArray2, 4, n);
            clientHandshakeContext.handshakeHash.finish();
            clientHandshakeContext.handshakeHash.deliver(byArray2);
            int n2 = serverHelloMessage.handshakeRecord.remaining();
            byte[] byArray3 = new byte[4 + n2];
            byArray3[0] = SSLHandshake.HELLO_RETRY_REQUEST.id;
            byArray3[1] = (byte)(n2 >> 16 & 0xFF);
            byArray3[2] = (byte)(n2 >> 8 & 0xFF);
            byArray3[3] = (byte)(n2 & 0xFF);
            ByteBuffer byteBuffer = serverHelloMessage.handshakeRecord.duplicate();
            byteBuffer.get(byArray3, 4, n2);
            clientHandshakeContext.handshakeHash.receive(byArray3);
            clientHandshakeContext.initialClientHelloMsg.extensions.reproduce(clientHandshakeContext, new SSLExtension[]{SSLExtension.CH_COOKIE, SSLExtension.CH_KEY_SHARE, SSLExtension.CH_PRE_SHARED_KEY});
            SSLHandshake.CLIENT_HELLO.produce(connectionContext, serverHelloMessage);
        }
    }

    private static final class T13ServerHelloConsumer
    implements HandshakeConsumer {
        private T13ServerHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SSLCipher.SSLWriteCipher sSLWriteCipher;
            SSLCipher.SSLReadCipher sSLReadCipher;
            Object object;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            ServerHelloMessage serverHelloMessage = (ServerHelloMessage)handshakeMessage;
            if (serverHelloMessage.serverVersion != ProtocolVersion.TLS12) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "The ServerHello.legacy_version field is not TLS 1.2");
            }
            clientHandshakeContext.negotiatedCipherSuite = serverHelloMessage.cipherSuite;
            clientHandshakeContext.handshakeHash.determine(clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.negotiatedCipherSuite);
            clientHandshakeContext.serverHelloRandom = serverHelloMessage.serverRandom;
            SSLExtension[] sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO);
            serverHelloMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            if (!clientHandshakeContext.isResumption) {
                if (clientHandshakeContext.resumingSession != null) {
                    clientHandshakeContext.resumingSession.invalidate();
                    clientHandshakeContext.resumingSession = null;
                }
                if (!clientHandshakeContext.sslConfig.enableSessionCreation) {
                    throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "New session creation is disabled");
                }
                clientHandshakeContext.handshakeSession = new SSLSessionImpl(clientHandshakeContext, clientHandshakeContext.negotiatedCipherSuite, serverHelloMessage.sessionId);
                clientHandshakeContext.handshakeSession.setMaximumPacketSize(clientHandshakeContext.sslConfig.maximumPacketSize);
            } else {
                object = clientHandshakeContext.resumingSession.consumePreSharedKey();
                if (object == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No PSK available. Unable to resume.");
                }
                clientHandshakeContext.handshakeSession = clientHandshakeContext.resumingSession;
                ServerHello.setUpPskKD(clientHandshakeContext, (SecretKey)object);
            }
            serverHelloMessage.extensions.consumeOnTrade(clientHandshakeContext, sSLExtensionArray);
            clientHandshakeContext.handshakeHash.update();
            object = clientHandshakeContext.handshakeKeyExchange;
            if (object == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not negotiated key shares");
            }
            SSLKeyDerivation sSLKeyDerivation = ((SSLKeyExchange)object).createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("TlsHandshakeSecret", null);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            SSLSecretDerivation sSLSecretDerivation = new SSLSecretDerivation(clientHandshakeContext, secretKey);
            SecretKey secretKey2 = sSLSecretDerivation.deriveKey("TlsServerHandshakeTrafficSecret", null);
            SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey2);
            SecretKey secretKey3 = sSLKeyDerivation2.deriveKey("TlsKey", null);
            SecretKey secretKey4 = sSLKeyDerivation2.deriveKey("TlsIv", null);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey4.getEncoded());
            try {
                sSLReadCipher = clientHandshakeContext.negotiatedCipherSuite.bulkCipher.createReadCipher(Authenticator.valueOf(clientHandshakeContext.negotiatedProtocol), clientHandshakeContext.negotiatedProtocol, secretKey3, ivParameterSpec, clientHandshakeContext.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Missing cipher algorithm", generalSecurityException);
            }
            if (sSLReadCipher == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)clientHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)clientHandshakeContext.negotiatedProtocol) + ")");
            }
            clientHandshakeContext.baseReadSecret = secretKey2;
            clientHandshakeContext.conContext.inputRecord.changeReadCiphers(sSLReadCipher);
            SecretKey secretKey5 = sSLSecretDerivation.deriveKey("TlsClientHandshakeTrafficSecret", null);
            SSLKeyDerivation sSLKeyDerivation3 = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey5);
            SecretKey secretKey6 = sSLKeyDerivation3.deriveKey("TlsKey", null);
            SecretKey secretKey7 = sSLKeyDerivation3.deriveKey("TlsIv", null);
            IvParameterSpec ivParameterSpec2 = new IvParameterSpec(secretKey7.getEncoded());
            try {
                sSLWriteCipher = clientHandshakeContext.negotiatedCipherSuite.bulkCipher.createWriteCipher(Authenticator.valueOf(clientHandshakeContext.negotiatedProtocol), clientHandshakeContext.negotiatedProtocol, secretKey6, ivParameterSpec2, clientHandshakeContext.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Missing cipher algorithm", generalSecurityException);
            }
            if (sSLWriteCipher == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)clientHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)clientHandshakeContext.negotiatedProtocol) + ")");
            }
            clientHandshakeContext.baseWriteSecret = secretKey5;
            clientHandshakeContext.conContext.outputRecord.changeWriteCiphers(sSLWriteCipher, serverHelloMessage.sessionId.length() != 0);
            clientHandshakeContext.handshakeKeyDerivation = sSLSecretDerivation;
            clientHandshakeContext.conContext.consumers.putIfAbsent(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t13Consumer);
            clientHandshakeContext.handshakeConsumers.put(SSLHandshake.ENCRYPTED_EXTENSIONS.id, SSLHandshake.ENCRYPTED_EXTENSIONS);
            clientHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
            clientHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            clientHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            clientHandshakeContext.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
        }
    }

    private static final class T12ServerHelloConsumer
    implements HandshakeConsumer {
        private T12ServerHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            final ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            ServerHelloMessage serverHelloMessage = (ServerHelloMessage)handshakeMessage;
            if (!clientHandshakeContext.isNegotiable(serverHelloMessage.serverVersion)) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "Server chose " + (Object)((Object)serverHelloMessage.serverVersion) + ", but that protocol version is not enabled or not supported by the client.");
            }
            clientHandshakeContext.negotiatedCipherSuite = serverHelloMessage.cipherSuite;
            clientHandshakeContext.handshakeHash.determine(clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.negotiatedCipherSuite);
            clientHandshakeContext.serverHelloRandom = serverHelloMessage.serverRandom;
            if (clientHandshakeContext.negotiatedCipherSuite.keyExchange == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "TLS 1.2 or prior version does not support the server cipher suite: " + clientHandshakeContext.negotiatedCipherSuite.name);
            }
            SSLExtension[] sSLExtensionArray = new SSLExtension[]{SSLExtension.SH_RENEGOTIATION_INFO};
            serverHelloMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            if (clientHandshakeContext.resumingSession != null) {
                if (serverHelloMessage.sessionId.equals(clientHandshakeContext.resumingSession.getSessionId())) {
                    object = clientHandshakeContext.resumingSession.getSuite();
                    if (clientHandshakeContext.negotiatedCipherSuite != object) {
                        throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "Server returned wrong cipher suite for session");
                    }
                    SSLHandshake[] sSLHandshakeArray = clientHandshakeContext.resumingSession.getProtocolVersion();
                    if (clientHandshakeContext.negotiatedProtocol != sSLHandshakeArray) {
                        throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "Server resumed with wrong protocol version");
                    }
                    if (((CipherSuite)((Object)object)).keyExchange == CipherSuite.KeyExchange.K_KRB5 || ((CipherSuite)((Object)object)).keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                        Subject subject;
                        Principal principal;
                        block25: {
                            principal = clientHandshakeContext.resumingSession.getLocalPrincipal();
                            subject = null;
                            try {
                                subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                    @Override
                                    public Subject run() throws Exception {
                                        return Krb5Helper.getClientSubject(clientHandshakeContext.conContext.acc);
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                subject = null;
                                if (!SSLLogger.isOn || !SSLLogger.isOn("session")) break block25;
                                SSLLogger.fine("Attempt to obtain subject failed!", new Object[0]);
                            }
                        }
                        if (subject != null) {
                            Set<Principal> set = subject.getPrincipals(Principal.class);
                            if (!set.contains(principal)) {
                                throw new SSLProtocolException("Server resumed session with wrong subject identity");
                            }
                            if (SSLLogger.isOn && SSLLogger.isOn("session")) {
                                SSLLogger.fine("Subject identity is same", new Object[0]);
                            }
                        } else {
                            if (SSLLogger.isOn && SSLLogger.isOn("session")) {
                                SSLLogger.fine("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false", new Object[0]);
                            }
                            throw new SSLProtocolException("Server resumed session with no subject");
                        }
                    }
                    clientHandshakeContext.isResumption = true;
                    clientHandshakeContext.resumingSession.setAsSessionResumption(true);
                    clientHandshakeContext.handshakeSession = clientHandshakeContext.resumingSession;
                } else {
                    if (clientHandshakeContext.resumingSession != null) {
                        clientHandshakeContext.resumingSession.invalidate();
                        clientHandshakeContext.resumingSession = null;
                    }
                    clientHandshakeContext.isResumption = false;
                    if (!clientHandshakeContext.sslConfig.enableSessionCreation) {
                        throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "New session creation is disabled");
                    }
                }
            }
            sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO);
            serverHelloMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            if (!clientHandshakeContext.isResumption) {
                if (clientHandshakeContext.resumingSession != null) {
                    clientHandshakeContext.resumingSession.invalidate();
                    clientHandshakeContext.resumingSession = null;
                }
                if (!clientHandshakeContext.sslConfig.enableSessionCreation) {
                    throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "New session creation is disabled");
                }
                clientHandshakeContext.handshakeSession = new SSLSessionImpl(clientHandshakeContext, clientHandshakeContext.negotiatedCipherSuite, serverHelloMessage.sessionId);
                clientHandshakeContext.handshakeSession.setMaximumPacketSize(clientHandshakeContext.sslConfig.maximumPacketSize);
            }
            serverHelloMessage.extensions.consumeOnTrade(clientHandshakeContext, sSLExtensionArray);
            if (clientHandshakeContext.isResumption) {
                object = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
                if (object == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
                }
                clientHandshakeContext.handshakeKeyDerivation = ((SSLTrafficKeyDerivation)object).createKeyDerivation(clientHandshakeContext, clientHandshakeContext.resumingSession.getMasterSecret());
                clientHandshakeContext.conContext.consumers.putIfAbsent(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t10Consumer);
                clientHandshakeContext.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            } else {
                clientHandshakeContext.handshakeKeyExchange = object = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
                if (object != null) {
                    for (SSLHandshake sSLHandshake : ((SSLKeyExchange)object).getRelatedHandshakers(clientHandshakeContext)) {
                        clientHandshakeContext.handshakeConsumers.put(sSLHandshake.id, sSLHandshake);
                    }
                }
                clientHandshakeContext.handshakeConsumers.put(SSLHandshake.SERVER_HELLO_DONE.id, SSLHandshake.SERVER_HELLO_DONE);
            }
        }
    }

    private static final class ServerHelloConsumer
    implements SSLConsumer {
        private ServerHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.SERVER_HELLO.id);
            if (!clientHandshakeContext.handshakeConsumers.isEmpty()) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "No more message expected before ServerHello is processed");
            }
            ServerHelloMessage serverHelloMessage = new ServerHelloMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ServerHello handshake message", serverHelloMessage);
            }
            if (serverHelloMessage.serverRandom.isHelloRetryRequest()) {
                this.onHelloRetryRequest(clientHandshakeContext, serverHelloMessage);
            } else {
                this.onServerHello(clientHandshakeContext, serverHelloMessage);
            }
        }

        private void onHelloRetryRequest(ClientHandshakeContext clientHandshakeContext, ServerHelloMessage serverHelloMessage) throws IOException {
            SSLExtension[] sSLExtensionArray = new SSLExtension[]{SSLExtension.HRR_SUPPORTED_VERSIONS};
            serverHelloMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            SupportedVersionsExtension.SHSupportedVersionsSpec sHSupportedVersionsSpec = (SupportedVersionsExtension.SHSupportedVersionsSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.HRR_SUPPORTED_VERSIONS);
            ProtocolVersion protocolVersion = sHSupportedVersionsSpec != null ? ProtocolVersion.valueOf(sHSupportedVersionsSpec.selectedVersion) : serverHelloMessage.serverVersion;
            if (!clientHandshakeContext.activeProtocols.contains((Object)protocolVersion)) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "The server selected protocol version " + (Object)((Object)protocolVersion) + " is not accepted by client preferences " + clientHandshakeContext.activeProtocols);
            }
            if (!protocolVersion.useTLS13PlusSpec()) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "Unexpected HelloRetryRequest for " + protocolVersion.name);
            }
            clientHandshakeContext.negotiatedProtocol = protocolVersion;
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Negotiated protocol version: " + protocolVersion.name, new Object[0]);
            }
            clientHandshakeContext.handshakePossessions.clear();
            t13HrrHandshakeConsumer.consume(clientHandshakeContext, serverHelloMessage);
        }

        private void onServerHello(ClientHandshakeContext clientHandshakeContext, ServerHelloMessage serverHelloMessage) throws IOException {
            SSLExtension[] sSLExtensionArray = new SSLExtension[]{SSLExtension.SH_SUPPORTED_VERSIONS};
            serverHelloMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            SupportedVersionsExtension.SHSupportedVersionsSpec sHSupportedVersionsSpec = (SupportedVersionsExtension.SHSupportedVersionsSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.SH_SUPPORTED_VERSIONS);
            ProtocolVersion protocolVersion = sHSupportedVersionsSpec != null ? ProtocolVersion.valueOf(sHSupportedVersionsSpec.selectedVersion) : serverHelloMessage.serverVersion;
            if (!clientHandshakeContext.activeProtocols.contains((Object)protocolVersion)) {
                throw clientHandshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "The server selected protocol version " + (Object)((Object)protocolVersion) + " is not accepted by client preferences " + clientHandshakeContext.activeProtocols);
            }
            clientHandshakeContext.negotiatedProtocol = protocolVersion;
            if (!clientHandshakeContext.conContext.isNegotiated) {
                clientHandshakeContext.conContext.protocolVersion = clientHandshakeContext.negotiatedProtocol;
                clientHandshakeContext.conContext.outputRecord.setVersion(clientHandshakeContext.negotiatedProtocol);
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Negotiated protocol version: " + protocolVersion.name, new Object[0]);
            }
            if (serverHelloMessage.serverRandom.isVersionDowngrade(clientHandshakeContext)) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "A potential protocol version downgrade attack");
            }
            if (protocolVersion.useTLS13PlusSpec()) {
                t13HandshakeConsumer.consume(clientHandshakeContext, serverHelloMessage);
            } else {
                clientHandshakeContext.handshakePossessions.clear();
                t12HandshakeConsumer.consume(clientHandshakeContext, serverHelloMessage);
            }
        }
    }

    private static final class T13HelloRetryRequestReproducer
    implements HandshakeProducer {
        private T13HelloRetryRequestReproducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            CipherSuite cipherSuite = serverHandshakeContext.negotiatedCipherSuite;
            ServerHelloMessage serverHelloMessage = new ServerHelloMessage(serverHandshakeContext, ProtocolVersion.TLS12, clientHelloMessage.sessionId, cipherSuite, RandomCookie.hrrRandom, clientHelloMessage);
            SSLExtension[] sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.MESSAGE_HASH, serverHandshakeContext.negotiatedProtocol);
            serverHelloMessage.extensions.produce(serverHandshakeContext, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Reproduced HelloRetryRequest handshake message", serverHelloMessage);
            }
            HandshakeOutStream handshakeOutStream = new HandshakeOutStream(null);
            serverHelloMessage.write(handshakeOutStream);
            return handshakeOutStream.toByteArray();
        }
    }

    private static final class T13HelloRetryRequestProducer
    implements HandshakeProducer {
        private T13HelloRetryRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            CipherSuite cipherSuite = T13ServerHelloProducer.chooseCipherSuite(serverHandshakeContext, clientHelloMessage);
            if (cipherSuite == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "no cipher suites in common for hello retry request");
            }
            ServerHelloMessage serverHelloMessage = new ServerHelloMessage(serverHandshakeContext, ProtocolVersion.TLS12, clientHelloMessage.sessionId, cipherSuite, RandomCookie.hrrRandom, clientHelloMessage);
            serverHandshakeContext.negotiatedCipherSuite = cipherSuite;
            serverHandshakeContext.handshakeHash.determine(serverHandshakeContext.negotiatedProtocol, serverHandshakeContext.negotiatedCipherSuite);
            SSLExtension[] sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.HELLO_RETRY_REQUEST, serverHandshakeContext.negotiatedProtocol);
            serverHelloMessage.extensions.produce(serverHandshakeContext, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced HelloRetryRequest handshake message", serverHelloMessage);
            }
            serverHelloMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.handshakeHash.finish();
            serverHandshakeContext.handshakeExtensions.clear();
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CLIENT_HELLO.id, SSLHandshake.CLIENT_HELLO);
            return null;
        }
    }

    private static final class T13ServerHelloProducer
    implements HandshakeProducer {
        private T13ServerHelloProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SSLCipher.SSLWriteCipher sSLWriteCipher;
            SSLCipher.SSLReadCipher sSLReadCipher;
            Object object;
            Object object2;
            Object object3;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            if (!serverHandshakeContext.isResumption || serverHandshakeContext.resumingSession == null) {
                if (!serverHandshakeContext.sslConfig.enableSessionCreation) {
                    throw new SSLException("Not resumption, and no new session is allowed");
                }
                if (serverHandshakeContext.localSupportedSignAlgs == null) {
                    serverHandshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, serverHandshakeContext.activeProtocols);
                }
                object3 = new SSLSessionImpl(serverHandshakeContext, CipherSuite.C_NULL);
                ((SSLSessionImpl)object3).setMaximumPacketSize(serverHandshakeContext.sslConfig.maximumPacketSize);
                serverHandshakeContext.handshakeSession = object3;
                object2 = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO, serverHandshakeContext.negotiatedProtocol);
                clientHelloMessage.extensions.consumeOnTrade(serverHandshakeContext, (SSLExtension[])object2);
                object = T13ServerHelloProducer.chooseCipherSuite(serverHandshakeContext, clientHelloMessage);
                if (object == null) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "no cipher suites in common");
                }
                serverHandshakeContext.negotiatedCipherSuite = object;
                serverHandshakeContext.handshakeSession.setSuite((CipherSuite)((Object)object));
                serverHandshakeContext.handshakeHash.determine(serverHandshakeContext.negotiatedProtocol, serverHandshakeContext.negotiatedCipherSuite);
            } else {
                serverHandshakeContext.handshakeSession = serverHandshakeContext.resumingSession;
                object3 = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO, serverHandshakeContext.negotiatedProtocol);
                clientHelloMessage.extensions.consumeOnTrade(serverHandshakeContext, (SSLExtension[])object3);
                serverHandshakeContext.negotiatedProtocol = serverHandshakeContext.resumingSession.getProtocolVersion();
                serverHandshakeContext.negotiatedCipherSuite = serverHandshakeContext.resumingSession.getSuite();
                serverHandshakeContext.handshakeHash.determine(serverHandshakeContext.negotiatedProtocol, serverHandshakeContext.negotiatedCipherSuite);
                ServerHello.setUpPskKD(serverHandshakeContext, serverHandshakeContext.resumingSession.consumePreSharedKey());
                object2 = (SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext();
                ((SSLSessionContextImpl)object2).remove(serverHandshakeContext.resumingSession.getSessionId());
            }
            serverHandshakeContext.handshakeProducers.put(SSLHandshake.ENCRYPTED_EXTENSIONS.id, SSLHandshake.ENCRYPTED_EXTENSIONS);
            serverHandshakeContext.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            object3 = new ServerHelloMessage(serverHandshakeContext, ProtocolVersion.TLS12, clientHelloMessage.sessionId, serverHandshakeContext.negotiatedCipherSuite, new RandomCookie(serverHandshakeContext), clientHelloMessage);
            serverHandshakeContext.serverHelloRandom = ((ServerHelloMessage)object3).serverRandom;
            object2 = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO, serverHandshakeContext.negotiatedProtocol);
            ((ServerHelloMessage)object3).extensions.produce(serverHandshakeContext, (SSLExtension[])object2);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ServerHello handshake message", object3);
            }
            ((SSLHandshake.HandshakeMessage)object3).write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.handshakeHash.update();
            object = serverHandshakeContext.handshakeKeyExchange;
            if (object == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not negotiated key shares");
            }
            SSLKeyDerivation sSLKeyDerivation = ((SSLKeyExchange)object).createKeyDerivation(serverHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("TlsHandshakeSecret", null);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            SSLSecretDerivation sSLSecretDerivation = new SSLSecretDerivation(serverHandshakeContext, secretKey);
            SecretKey secretKey2 = sSLSecretDerivation.deriveKey("TlsClientHandshakeTrafficSecret", null);
            SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey2);
            SecretKey secretKey3 = sSLKeyDerivation2.deriveKey("TlsKey", null);
            SecretKey secretKey4 = sSLKeyDerivation2.deriveKey("TlsIv", null);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey4.getEncoded());
            try {
                sSLReadCipher = serverHandshakeContext.negotiatedCipherSuite.bulkCipher.createReadCipher(Authenticator.valueOf(serverHandshakeContext.negotiatedProtocol), serverHandshakeContext.negotiatedProtocol, secretKey3, ivParameterSpec, serverHandshakeContext.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Missing cipher algorithm", generalSecurityException);
            }
            if (sSLReadCipher == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)serverHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)serverHandshakeContext.negotiatedProtocol) + ")");
            }
            serverHandshakeContext.baseReadSecret = secretKey2;
            serverHandshakeContext.conContext.inputRecord.changeReadCiphers(sSLReadCipher);
            SecretKey secretKey5 = sSLSecretDerivation.deriveKey("TlsServerHandshakeTrafficSecret", null);
            SSLKeyDerivation sSLKeyDerivation3 = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey5);
            SecretKey secretKey6 = sSLKeyDerivation3.deriveKey("TlsKey", null);
            SecretKey secretKey7 = sSLKeyDerivation3.deriveKey("TlsIv", null);
            IvParameterSpec ivParameterSpec2 = new IvParameterSpec(secretKey7.getEncoded());
            try {
                sSLWriteCipher = serverHandshakeContext.negotiatedCipherSuite.bulkCipher.createWriteCipher(Authenticator.valueOf(serverHandshakeContext.negotiatedProtocol), serverHandshakeContext.negotiatedProtocol, secretKey6, ivParameterSpec2, serverHandshakeContext.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Missing cipher algorithm", generalSecurityException);
            }
            if (sSLWriteCipher == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)serverHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)serverHandshakeContext.negotiatedProtocol) + ")");
            }
            serverHandshakeContext.baseWriteSecret = secretKey5;
            serverHandshakeContext.conContext.outputRecord.changeWriteCiphers(sSLWriteCipher, clientHelloMessage.sessionId.length() != 0);
            serverHandshakeContext.handshakeKeyDerivation = sSLSecretDerivation;
            return null;
        }

        private static CipherSuite chooseCipherSuite(ServerHandshakeContext serverHandshakeContext, ClientHello.ClientHelloMessage clientHelloMessage) throws IOException {
            List list;
            List<CipherSuite> list2;
            if (serverHandshakeContext.sslConfig.preferLocalCipherSuites) {
                list2 = serverHandshakeContext.activeCipherSuites;
                list = clientHelloMessage.cipherSuites;
            } else {
                list2 = clientHelloMessage.cipherSuites;
                list = serverHandshakeContext.activeCipherSuites;
            }
            CipherSuite cipherSuite = null;
            AlgorithmConstraints algorithmConstraints = ServerHandshakeContext.legacyAlgorithmConstraints;
            for (CipherSuite cipherSuite2 : list2) {
                if (!HandshakeContext.isNegotiable(list, serverHandshakeContext.negotiatedProtocol, cipherSuite2)) continue;
                if (cipherSuite == null && !algorithmConstraints.permits(null, cipherSuite2.name, null)) {
                    cipherSuite = cipherSuite2;
                    continue;
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("use cipher suite " + cipherSuite2.name, new Object[0]);
                }
                return cipherSuite2;
            }
            if (cipherSuite != null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("use legacy cipher suite " + cipherSuite.name, new Object[0]);
                }
                return cipherSuite;
            }
            return null;
        }
    }

    private static final class T12ServerHelloProducer
    implements HandshakeProducer {
        private T12ServerHelloProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            SSLExtension[] sSLExtensionArray;
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            if (!serverHandshakeContext.isResumption || serverHandshakeContext.resumingSession == null) {
                if (!serverHandshakeContext.sslConfig.enableSessionCreation) {
                    throw new SSLException("Not resumption, and no new session is allowed");
                }
                if (serverHandshakeContext.localSupportedSignAlgs == null) {
                    serverHandshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, serverHandshakeContext.activeProtocols);
                }
                object2 = new SSLSessionImpl(serverHandshakeContext, CipherSuite.C_NULL);
                ((SSLSessionImpl)object2).setMaximumPacketSize(serverHandshakeContext.sslConfig.maximumPacketSize);
                serverHandshakeContext.handshakeSession = object2;
                sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO, serverHandshakeContext.negotiatedProtocol);
                clientHelloMessage.extensions.consumeOnTrade(serverHandshakeContext, sSLExtensionArray);
                object = T12ServerHelloProducer.chooseCipherSuite(serverHandshakeContext, clientHelloMessage);
                if (object == null) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "no cipher suites in common");
                }
                serverHandshakeContext.negotiatedCipherSuite = ((KeyExchangeProperties)object).cipherSuite;
                serverHandshakeContext.handshakeKeyExchange = ((KeyExchangeProperties)object).keyExchange;
                serverHandshakeContext.handshakeSession.setSuite(((KeyExchangeProperties)object).cipherSuite);
                serverHandshakeContext.handshakePossessions.addAll(Arrays.asList(((KeyExchangeProperties)object).possessions));
                serverHandshakeContext.handshakeHash.determine(serverHandshakeContext.negotiatedProtocol, serverHandshakeContext.negotiatedCipherSuite);
                serverHandshakeContext.stapleParams = StatusResponseManager.processStapling(serverHandshakeContext);
                serverHandshakeContext.staplingActive = serverHandshakeContext.stapleParams != null;
                SSLKeyExchange sSLKeyExchange = ((KeyExchangeProperties)object).keyExchange;
                if (sSLKeyExchange != null) {
                    for (Map.Entry<Byte, HandshakeProducer> object3 : sSLKeyExchange.getHandshakeProducers(serverHandshakeContext)) {
                        serverHandshakeContext.handshakeProducers.put(object3.getKey(), object3.getValue());
                    }
                }
                if (sSLKeyExchange != null && serverHandshakeContext.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_NONE && !serverHandshakeContext.negotiatedCipherSuite.isAnonymous()) {
                    for (SSLHandshake sSLHandshake : sSLKeyExchange.getRelatedHandshakers(serverHandshakeContext)) {
                        if (sSLHandshake != SSLHandshake.CERTIFICATE) continue;
                        serverHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
                        break;
                    }
                }
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.SERVER_HELLO_DONE.id, SSLHandshake.SERVER_HELLO_DONE);
            } else {
                serverHandshakeContext.handshakeSession = serverHandshakeContext.resumingSession;
                serverHandshakeContext.negotiatedProtocol = serverHandshakeContext.resumingSession.getProtocolVersion();
                serverHandshakeContext.negotiatedCipherSuite = serverHandshakeContext.resumingSession.getSuite();
                serverHandshakeContext.handshakeHash.determine(serverHandshakeContext.negotiatedProtocol, serverHandshakeContext.negotiatedCipherSuite);
            }
            object2 = new ServerHelloMessage(serverHandshakeContext, serverHandshakeContext.negotiatedProtocol, serverHandshakeContext.handshakeSession.getSessionId(), serverHandshakeContext.negotiatedCipherSuite, new RandomCookie(serverHandshakeContext), clientHelloMessage);
            serverHandshakeContext.serverHelloRandom = ((ServerHelloMessage)object2).serverRandom;
            sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO, serverHandshakeContext.negotiatedProtocol);
            ((ServerHelloMessage)object2).extensions.produce(serverHandshakeContext, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ServerHello handshake message", object2);
            }
            ((SSLHandshake.HandshakeMessage)object2).write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            if (serverHandshakeContext.isResumption && serverHandshakeContext.resumingSession != null) {
                object = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
                if (object == null) {
                    throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
                }
                serverHandshakeContext.handshakeKeyDerivation = ((SSLTrafficKeyDerivation)object).createKeyDerivation(serverHandshakeContext, serverHandshakeContext.resumingSession.getMasterSecret());
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            }
            return null;
        }

        private static KeyExchangeProperties chooseCipherSuite(ServerHandshakeContext serverHandshakeContext, ClientHello.ClientHelloMessage clientHelloMessage) throws IOException {
            SSLPossession[] sSLPossessionArray;
            SSLKeyExchange sSLKeyExchange;
            List list;
            List<CipherSuite> list2;
            if (serverHandshakeContext.sslConfig.preferLocalCipherSuites) {
                list2 = serverHandshakeContext.activeCipherSuites;
                list = clientHelloMessage.cipherSuites;
            } else {
                list2 = clientHelloMessage.cipherSuites;
                list = serverHandshakeContext.activeCipherSuites;
            }
            LinkedList<CipherSuite> linkedList = new LinkedList<CipherSuite>();
            for (CipherSuite cipherSuite : list2) {
                if (!HandshakeContext.isNegotiable(list, serverHandshakeContext.negotiatedProtocol, cipherSuite) || serverHandshakeContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED && (cipherSuite.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || cipherSuite.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) || (sSLKeyExchange = SSLKeyExchange.valueOf(cipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol)) == null) continue;
                if (!ServerHandshakeContext.legacyAlgorithmConstraints.permits(null, cipherSuite.name, null)) {
                    linkedList.add(cipherSuite);
                    continue;
                }
                sSLPossessionArray = sSLKeyExchange.createPossessions(serverHandshakeContext);
                if (sSLPossessionArray == null || sSLPossessionArray.length == 0) continue;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("use cipher suite " + cipherSuite.name, new Object[0]);
                }
                return new KeyExchangeProperties(cipherSuite, sSLKeyExchange, sSLPossessionArray);
            }
            for (CipherSuite cipherSuite : linkedList) {
                sSLKeyExchange = SSLKeyExchange.valueOf(cipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
                if (sSLKeyExchange == null || (sSLPossessionArray = sSLKeyExchange.createPossessions(serverHandshakeContext)) == null || sSLPossessionArray.length == 0) continue;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("use legacy cipher suite " + cipherSuite.name, new Object[0]);
                }
                return new KeyExchangeProperties(cipherSuite, sSLKeyExchange, sSLPossessionArray);
            }
            throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "no cipher suites in common");
        }

        private static final class KeyExchangeProperties {
            final CipherSuite cipherSuite;
            final SSLKeyExchange keyExchange;
            final SSLPossession[] possessions;

            private KeyExchangeProperties(CipherSuite cipherSuite, SSLKeyExchange sSLKeyExchange, SSLPossession[] sSLPossessionArray) {
                this.cipherSuite = cipherSuite;
                this.keyExchange = sSLKeyExchange;
                this.possessions = sSLPossessionArray;
            }
        }
    }

    static final class ServerHelloMessage
    extends SSLHandshake.HandshakeMessage {
        final ProtocolVersion serverVersion;
        final RandomCookie serverRandom;
        final SessionId sessionId;
        final CipherSuite cipherSuite;
        final byte compressionMethod;
        final SSLExtensions extensions;
        final ClientHello.ClientHelloMessage clientHello;
        final ByteBuffer handshakeRecord;

        ServerHelloMessage(HandshakeContext handshakeContext, ProtocolVersion protocolVersion, SessionId sessionId, CipherSuite cipherSuite, RandomCookie randomCookie, ClientHello.ClientHelloMessage clientHelloMessage) {
            super(handshakeContext);
            this.serverVersion = protocolVersion;
            this.serverRandom = randomCookie;
            this.sessionId = sessionId;
            this.cipherSuite = cipherSuite;
            this.compressionMethod = 0;
            this.extensions = new SSLExtensions(this);
            this.clientHello = clientHelloMessage;
            this.handshakeRecord = null;
        }

        ServerHelloMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            this.handshakeRecord = byteBuffer.duplicate();
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            this.serverVersion = ProtocolVersion.valueOf(by, by2);
            if (this.serverVersion == null) {
                throw handshakeContext.conContext.fatal(Alert.PROTOCOL_VERSION, "Unsupported protocol version: " + ProtocolVersion.nameOf(by, by2));
            }
            this.serverRandom = new RandomCookie(byteBuffer);
            this.sessionId = new SessionId(Record.getBytes8(byteBuffer));
            try {
                this.sessionId.checkLength(this.serverVersion.id);
            }
            catch (SSLProtocolException sSLProtocolException) {
                throw this.handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, sSLProtocolException);
            }
            int n = Record.getInt16(byteBuffer);
            this.cipherSuite = CipherSuite.valueOf(n);
            if (this.cipherSuite == null || !handshakeContext.isNegotiable(this.cipherSuite)) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Server selected improper ciphersuite " + CipherSuite.nameOf(n));
            }
            this.compressionMethod = byteBuffer.get();
            if (this.compressionMethod != 0) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "compression type not supported, " + this.compressionMethod);
            }
            SSLExtension[] sSLExtensionArray = this.serverRandom.isHelloRetryRequest() ? handshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.HELLO_RETRY_REQUEST) : handshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO);
            this.extensions = byteBuffer.hasRemaining() ? new SSLExtensions(this, byteBuffer, sSLExtensionArray) : new SSLExtensions(this);
            this.clientHello = null;
        }

        @Override
        public SSLHandshake handshakeType() {
            return this.serverRandom.isHelloRetryRequest() ? SSLHandshake.HELLO_RETRY_REQUEST : SSLHandshake.SERVER_HELLO;
        }

        @Override
        public int messageLength() {
            return 38 + this.sessionId.length() + this.extensions.length();
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.serverVersion.major);
            handshakeOutStream.putInt8(this.serverVersion.minor);
            handshakeOutStream.write(this.serverRandom.randomBytes);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            handshakeOutStream.putInt8(this.cipherSuite.id >> 8 & 0xFF);
            handshakeOutStream.putInt8(this.cipherSuite.id & 0xFF);
            handshakeOutStream.putInt8(this.compressionMethod);
            this.extensions.send(handshakeOutStream);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"{0}\": '{'\n  \"server version\"      : \"{1}\",\n  \"random\"              : \"{2}\",\n  \"session id\"          : \"{3}\",\n  \"cipher suite\"        : \"{4}\",\n  \"compression methods\" : \"{5}\",\n  \"extensions\"          : [\n{6}\n  ]\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{this.serverRandom.isHelloRetryRequest() ? "HelloRetryRequest" : "ServerHello", this.serverVersion.name, Utilities.toHexString(this.serverRandom.randomBytes), this.sessionId.toString(), this.cipherSuite.name + "(" + Utilities.byte16HexString(this.cipherSuite.id) + ")", Utilities.toHexString(this.compressionMethod), Utilities.indent(this.extensions.toString(), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

