/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoContent;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509CRL;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Certificate;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Digest;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509Data
extends SignatureElementProxy
implements KeyInfoContent {
    private static final Logger LOG = Logger.getLogger(X509Data.class.getName());

    public X509Data(Document document) {
        super(document);
        this.addReturnToSelf();
    }

    public X509Data(Element element, String string) throws XMLSecurityException {
        super(element, string);
        Node node;
        for (node = this.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node == null || node.getNodeType() != 1) {
            Object[] objectArray = new Object[]{"Elements", "X509Data"};
            throw new XMLSecurityException("xml.WrongContent", objectArray);
        }
    }

    public void addIssuerSerial(String string, BigInteger bigInteger) {
        this.add(new XMLX509IssuerSerial(this.getDocument(), string, bigInteger));
    }

    public void addIssuerSerial(String string, String string2) {
        this.add(new XMLX509IssuerSerial(this.getDocument(), string, string2));
    }

    public void addIssuerSerial(String string, int n) {
        this.add(new XMLX509IssuerSerial(this.getDocument(), string, n));
    }

    public void add(XMLX509IssuerSerial xMLX509IssuerSerial) {
        this.appendSelf(xMLX509IssuerSerial);
        this.addReturnToSelf();
    }

    public void addSKI(byte[] byArray) {
        this.add(new XMLX509SKI(this.getDocument(), byArray));
    }

    public void addSKI(X509Certificate x509Certificate) throws XMLSecurityException {
        this.add(new XMLX509SKI(this.getDocument(), x509Certificate));
    }

    public void add(XMLX509SKI xMLX509SKI) {
        this.appendSelf(xMLX509SKI);
        this.addReturnToSelf();
    }

    public void addSubjectName(String string) {
        this.add(new XMLX509SubjectName(this.getDocument(), string));
    }

    public void addSubjectName(X509Certificate x509Certificate) {
        this.add(new XMLX509SubjectName(this.getDocument(), x509Certificate));
    }

    public void add(XMLX509SubjectName xMLX509SubjectName) {
        this.appendSelf(xMLX509SubjectName);
        this.addReturnToSelf();
    }

    public void addCertificate(X509Certificate x509Certificate) throws XMLSecurityException {
        this.add(new XMLX509Certificate(this.getDocument(), x509Certificate));
    }

    public void addCertificate(byte[] byArray) {
        this.add(new XMLX509Certificate(this.getDocument(), byArray));
    }

    public void add(XMLX509Certificate xMLX509Certificate) {
        this.appendSelf(xMLX509Certificate);
        this.addReturnToSelf();
    }

    public void addCRL(byte[] byArray) {
        this.add(new XMLX509CRL(this.getDocument(), byArray));
    }

    public void add(XMLX509CRL xMLX509CRL) {
        this.appendSelf(xMLX509CRL);
        this.addReturnToSelf();
    }

    public void addDigest(X509Certificate x509Certificate, String string) throws XMLSecurityException {
        this.add(new XMLX509Digest(this.getDocument(), x509Certificate, string));
    }

    public void addDigest(byte[] byArray, String string) {
        this.add(new XMLX509Digest(this.getDocument(), byArray, string));
    }

    public void add(XMLX509Digest xMLX509Digest) {
        this.appendSelf(xMLX509Digest);
        this.addReturnToSelf();
    }

    public void addUnknownElement(Element element) {
        this.appendSelf(element);
        this.addReturnToSelf();
    }

    public int lengthIssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public int lengthSKI() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509SKI");
    }

    public int lengthSubjectName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName");
    }

    public int lengthCertificate() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
    }

    public int lengthCRL() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509CRL");
    }

    public int lengthDigest() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "X509Digest");
    }

    public int lengthUnknownElement() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++n;
        }
        return n;
    }

    public XMLX509IssuerSerial itemIssuerSerial(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "X509IssuerSerial", n);
        if (element != null) {
            return new XMLX509IssuerSerial(element, this.baseURI);
        }
        return null;
    }

    public XMLX509SKI itemSKI(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "X509SKI", n);
        if (element != null) {
            return new XMLX509SKI(element, this.baseURI);
        }
        return null;
    }

    public XMLX509SubjectName itemSubjectName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "X509SubjectName", n);
        if (element != null) {
            return new XMLX509SubjectName(element, this.baseURI);
        }
        return null;
    }

    public XMLX509Certificate itemCertificate(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "X509Certificate", n);
        if (element != null) {
            return new XMLX509Certificate(element, this.baseURI);
        }
        return null;
    }

    public XMLX509CRL itemCRL(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "X509CRL", n);
        if (element != null) {
            return new XMLX509CRL(element, this.baseURI);
        }
        return null;
    }

    public XMLX509Digest itemDigest(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDs11Node(this.getFirstChild(), "X509Digest", n);
        if (element != null) {
            return new XMLX509Digest(element, this.baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        LOG.log(Level.FINE, "itemUnknownElement not implemented: " + n + "");
        return null;
    }

    public boolean containsIssuerSerial() {
        return this.lengthIssuerSerial() > 0;
    }

    public boolean containsSKI() {
        return this.lengthSKI() > 0;
    }

    public boolean containsSubjectName() {
        return this.lengthSubjectName() > 0;
    }

    public boolean containsCertificate() {
        return this.lengthCertificate() > 0;
    }

    public boolean containsDigest() {
        return this.lengthDigest() > 0;
    }

    public boolean containsCRL() {
        return this.lengthCRL() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    @Override
    public String getBaseLocalName() {
        return "X509Data";
    }
}

