/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoReference;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class KeyInfoReferenceResolver
extends KeyResolverSpi {
    private static final Logger LOG = Logger.getLogger(KeyInfoReferenceResolver.class.getName());

    @Override
    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignature11Space(element, "KeyInfoReference");
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.log(Level.FINE, "Can I resolve " + element.getTagName() + "");
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
            if (keyInfo != null) {
                return keyInfo.getPublicKey();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.log(Level.FINE, "Can I resolve " + element.getTagName() + "");
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
            if (keyInfo != null) {
                return keyInfo.getX509Certificate();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.log(Level.FINE, "Can I resolve " + element.getTagName() + "");
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
            if (keyInfo != null) {
                return keyInfo.getSecretKey();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    @Override
    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.log(Level.FINE, "Can I resolve " + element.getTagName());
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver);
            if (keyInfo != null) {
                return keyInfo.getPrivateKey();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    private KeyInfo resolveReferentKeyInfo(Element element, String string, StorageResolver storageResolver) throws XMLSecurityException {
        KeyInfoReference keyInfoReference = new KeyInfoReference(element, string);
        Attr attr = keyInfoReference.getURIAttr();
        XMLSignatureInput xMLSignatureInput = this.resolveInput(attr, string, this.secureValidation);
        Element element2 = null;
        try {
            element2 = this.obtainReferenceElement(xMLSignatureInput);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "XMLSecurityException", exception);
            return null;
        }
        if (element2 == null) {
            LOG.log(Level.FINE, "De-reference of KeyInfoReference URI returned null: " + attr.getValue() + "");
            return null;
        }
        this.validateReference(element2);
        KeyInfo keyInfo = new KeyInfo(element2, string);
        keyInfo.addStorageResolver(storageResolver);
        return keyInfo;
    }

    private void validateReference(Element element) throws XMLSecurityException {
        if (!XMLUtils.elementIsInSignatureSpace(element, "KeyInfo")) {
            Object[] objectArray = new Object[]{new QName(element.getNamespaceURI(), element.getLocalName())};
            throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.WrongType", objectArray);
        }
        KeyInfo keyInfo = new KeyInfo(element, "");
        if (keyInfo.containsKeyInfoReference()) {
            if (this.secureValidation) {
                throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.ReferenceWithSecure");
            }
            throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.ReferenceWithoutSecure");
        }
    }

    private XMLSignatureInput resolveInput(Attr attr, String string, boolean bl) throws XMLSecurityException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string, bl);
        return resourceResolver.resolve(attr, string, bl);
    }

    private Element obtainReferenceElement(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else {
            if (xMLSignatureInput.isNodeSet()) {
                LOG.log(Level.FINE, "De-reference of KeyInfoReference returned an unsupported NodeSet");
                return null;
            }
            byte[] byArray = xMLSignatureInput.getBytes();
            element = KeyInfoReferenceResolver.getDocFromBytes(byArray, this.secureValidation);
        }
        return element;
    }
}

