/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    private static final Logger LOG = Logger.getLogger(ResolverFragment.class.getName());

    @Override
    public boolean engineIsThreadSafe() {
        return true;
    }

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object object;
        Document document = resourceResolverContext.attr.getOwnerElement().getOwnerDocument();
        Node node = null;
        if (resourceResolverContext.uriToResolve.equals("")) {
            LOG.log(Level.FINE, "ResolverFragment with empty URI (means complete document)");
            node = document;
        } else {
            Element element;
            object = resourceResolverContext.uriToResolve.substring(1);
            node = document.getElementById((String)object);
            if (node == null) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
            if (resourceResolverContext.secureValidation && !XMLUtils.protectAgainstWrappingAttack(element = resourceResolverContext.attr.getOwnerDocument().getDocumentElement(), (String)object)) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
            LOG.log(Level.FINE, "Try to catch an Element with ID " + (String)object + " and Element was {}", node);
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setSecureValidation(resourceResolverContext.secureValidation);
        ((XMLSignatureInput)object).setExcludeComments(true);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (resourceResolverContext.baseUri != null && resourceResolverContext.baseUri.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.baseUri.concat(resourceResolverContext.uriToResolve));
        } else {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.uriToResolve);
        }
        return object;
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            LOG.log(Level.FINE, "Quick fail for null uri");
            return false;
        }
        if (resourceResolverContext.uriToResolve.equals("") || resourceResolverContext.uriToResolve.charAt(0) == '#' && !resourceResolverContext.uriToResolve.startsWith("#xpointer(")) {
            LOG.log(Level.FINE, "State I can resolve reference: '" + resourceResolverContext.uriToResolve + "'");
            return true;
        }
        LOG.log(Level.FINE, "Do not seem to be able to resolve reference: '" + resourceResolverContext.uriToResolve + "'");
        return false;
    }
}

