/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    private static final Logger LOG = Logger.getLogger(ResolverXPointer.class.getName());
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();

    @Override
    public boolean engineIsThreadSafe() {
        return true;
    }

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = resourceResolverContext.attr.getOwnerElement().getOwnerDocument();
        if (ResolverXPointer.isXPointerSlash(resourceResolverContext.uriToResolve)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(resourceResolverContext.uriToResolve)) {
            Object[] objectArray;
            object = ResolverXPointer.getXPointerId(resourceResolverContext.uriToResolve);
            node = document.getElementById((String)object);
            if (resourceResolverContext.secureValidation && !XMLUtils.protectAgainstWrappingAttack((Node)(objectArray = resourceResolverContext.attr.getOwnerDocument().getDocumentElement()), (String)object)) {
                Object[] objectArray2 = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", objectArray2, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
            if (node == null) {
                objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setSecureValidation(resourceResolverContext.secureValidation);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (resourceResolverContext.baseUri != null && resourceResolverContext.baseUri.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.baseUri.concat(resourceResolverContext.uriToResolve));
        } else {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.uriToResolve);
        }
        return object;
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            return false;
        }
        return ResolverXPointer.isXPointerSlash(resourceResolverContext.uriToResolve) || ResolverXPointer.isXPointerId(resourceResolverContext.uriToResolve);
    }

    private static boolean isXPointerSlash(String string) {
        return string.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Id = " + string2.substring(1, n));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                return string2.substring(1, n);
            }
        }
        return null;
    }
}

