/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

class HRuleView
extends View {
    private Border bevel;
    private float topMargin;
    private float bottomMargin;
    private float leftMargin;
    private float rightMargin;
    private int alignment = 0;
    private String noshade = null;
    private int size = 0;
    private CSS.LengthValue widthValue;
    private static final int SPACE_ABOVE = 3;
    private static final int SPACE_BELOW = 3;
    private AttributeSet attr;

    public HRuleView(Element element) {
        super(element);
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        Object object;
        StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        AttributeSet attributeSet = this.getElement().getAttributes();
        this.attr = styleSheet.getViewAttributes(this);
        this.alignment = 0;
        this.size = 0;
        this.noshade = null;
        this.widthValue = null;
        Enumeration enumeration = this.attr.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
        }
        if (this.attr != null) {
            this.alignment = StyleConstants.getAlignment(this.attr);
            this.noshade = (String)attributeSet.getAttribute("noshade");
            object = this.attr.getAttribute("size");
            if (object != null && object instanceof String) {
                this.size = Integer.parseInt((String)object);
            }
            if ((object = this.attr.getAttribute(CSS.Attribute.WIDTH)) != null && object instanceof CSS.LengthValue) {
                this.widthValue = (CSS.LengthValue)object;
            }
            this.topMargin = this.getLength(CSS.Attribute.MARGIN_TOP, this.attr);
            this.bottomMargin = this.getLength(CSS.Attribute.MARGIN_BOTTOM, this.attr);
            this.leftMargin = this.getLength(CSS.Attribute.MARGIN_LEFT, this.attr);
            this.rightMargin = this.getLength(CSS.Attribute.MARGIN_RIGHT, this.attr);
        } else {
            this.rightMargin = 0.0f;
            this.leftMargin = 0.0f;
            this.bottomMargin = 0.0f;
            this.topMargin = 0.0f;
        }
        if (this.bevel == null) {
            this.bevel = BorderFactory.createLoweredBevelBorder();
        }
    }

    private float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(attribute);
        float f = lengthValue != null ? lengthValue.getValue() : 0.0f;
        return f;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        int n = 0;
        int n2 = rectangle.y + 3 + (int)this.topMargin;
        int n3 = rectangle.width - (int)(this.leftMargin + this.rightMargin);
        if (this.widthValue != null) {
            n3 = (int)this.widthValue.getValue(n3);
        }
        int n4 = rectangle.height - (6 + (int)this.topMargin + (int)this.bottomMargin);
        if (this.size > 0) {
            n4 = this.size;
        }
        switch (this.alignment) {
            case 1: {
                n = rectangle.x + rectangle.width / 2 - n3 / 2;
                break;
            }
            case 2: {
                n = rectangle.x + rectangle.width - n3 - (int)this.rightMargin;
                break;
            }
            default: {
                n = rectangle.x + (int)this.leftMargin;
            }
        }
        if (this.noshade == "#DEFAULT") {
            graphics.fillRect(n, n2, n3, n4);
        } else {
            this.bevel.paintBorder(this.getContainer(), graphics, n, n2, n3, n4);
        }
    }

    public float getPreferredSpan(int n) {
        Insets insets = this.bevel.getBorderInsets(this.getContainer());
        switch (n) {
            case 0: {
                return insets.left + insets.right;
            }
            case 1: {
                if (this.size > 0) {
                    return (float)(this.size + 3 + 3) + this.topMargin + this.bottomMargin;
                }
                if (this.noshade == "#DEFAULT") {
                    return 7.0f + this.topMargin + this.bottomMargin;
                }
                return (float)(insets.top + insets.bottom + 3 + 3) + this.topMargin + this.bottomMargin;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public int getResizeWeight(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        return 0;
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (n == 0) {
            return 3000;
        }
        return 0;
    }

    public View breakView(int n, int n2, float f, float f2) {
        return null;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n = documentEvent.getOffset();
        if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }
}

