/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.AudioFormat;

public class AudioFileFormat {
    private Type type;
    private int byteLength;
    private AudioFormat format;
    private int frameLength;

    protected AudioFileFormat(Type type, int n, AudioFormat audioFormat, int n2) {
        this.type = type;
        this.byteLength = n;
        this.format = audioFormat;
        this.frameLength = n2;
    }

    public AudioFileFormat(Type type, AudioFormat audioFormat, int n) {
        this(type, -1, audioFormat, n);
    }

    public Type getType() {
        return this.type;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.type.toString() + " (." + this.type.getExtension() + ") file");
        if (this.byteLength != -1) {
            stringBuffer.append(", byte length: " + this.byteLength);
        }
        stringBuffer.append(", data format: " + this.format);
        if (this.frameLength != -1) {
            stringBuffer.append(", frame length: " + this.frameLength);
        }
        return new String(stringBuffer);
    }

    public static class Type {
        public static final Type WAVE = new Type("WAVE", "wav");
        public static final Type AU = new Type("AU", "au");
        public static final Type AIFF = new Type("AIFF", "aif");
        public static final Type AIFC = new Type("AIFF-C", "aifc");
        public static final Type SND = new Type("SND", "snd");
        private final String name;
        private final String extension;

        protected Type(String string, String string2) {
            this.name = string;
            this.extension = string2;
        }

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

