/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Burst
extends AbstractTool {
    public Burst() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Burst", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            File file2 = file.getParentFile();
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf("."));
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n = pdfReader.getNumberOfPages();
            int n2 = 1 + n / 10;
            System.out.println("There are " + n + " pages in the original file.");
            for (int i = 0; i < n; ++i) {
                int n3 = i + 1;
                String string2 = String.valueOf(n3);
                while (string2.length() < n2) {
                    string2 = "0" + string2;
                }
                string2 = "_" + string2 + ".pdf";
                Document document = new Document(pdfReader.getPageSizeWithRotation(n3));
                PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(new File(file2, string + string2)));
                document.open();
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n3);
                int n4 = pdfReader.getPageRotation(n3);
                if (n4 == 90 || n4 == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, pdfReader.getPageSizeWithRotation(n3).height());
                } else {
                    pdfContentByte.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                document.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Burst burst = new Burst();
        if (stringArray.length < 1) {
            System.err.println(burst.getUsage());
        }
        burst.setArguments(stringArray);
        burst.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }

    static {
        Burst.addVersion("$Id: Burst.java,v 1.5 2005/09/09 08:51:14 blowagie Exp $");
    }
}

