/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import sun.java2d.pipe.Region;

public class RegionIterator {
    Region region;
    int curIndex;
    int numXbands;

    RegionIterator(Region region) {
        this.region = region;
    }

    public RegionIterator createCopy() {
        RegionIterator regionIterator = new RegionIterator(this.region);
        regionIterator.curIndex = this.curIndex;
        regionIterator.numXbands = this.numXbands;
        return regionIterator;
    }

    public void copyStateFrom(RegionIterator regionIterator) {
        if (this.region != regionIterator.region) {
            throw new InternalError("region mismatch");
        }
        this.curIndex = regionIterator.curIndex;
        this.numXbands = regionIterator.numXbands;
    }

    public boolean nextYRange(int[] nArray) {
        this.curIndex += this.numXbands * 2;
        this.numXbands = 0;
        if (this.curIndex >= this.region.endIndex) {
            return false;
        }
        nArray[0] = this.region.bands[this.curIndex++];
        nArray[1] = this.region.bands[this.curIndex++];
        this.numXbands = this.region.bands[this.curIndex++];
        return true;
    }

    public boolean nextXBand(int[] nArray) {
        if (this.numXbands <= 0) {
            return false;
        }
        --this.numXbands;
        nArray[2] = this.region.bands[this.curIndex++];
        nArray[3] = this.region.bands[this.curIndex++];
        return true;
    }
}

